/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.rest.noeyeball.welcomeguide;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/welcome-guide/item-completer")
public class WelcomeGuideItemCompleterResource {
    private final JiraAuthenticationContext authenticationContext;
    private final OnBoardingPropertiesService onBoardingPropertiesService;

    @Autowired
    public WelcomeGuideItemCompleterResource(JiraAuthenticationContext authenticationContext, OnBoardingPropertiesService onBoardingPropertiesService) {
        this.authenticationContext = authenticationContext;
        this.onBoardingPropertiesService = onBoardingPropertiesService;
    }

    @POST
    @Path(value="/completeItem/{itemName}")
    public Response completeChecklistItem(@PathParam(value="itemName") String itemName) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        this.onBoardingPropertiesService.setChecklistItemCompleted(user, itemName);
        return Response.noContent().build();
    }
}

