/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.rest.customerchannels;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.api.project.PortalUrls;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.project.internal.rest.customerchannels.CustomerChannelsResponse;
import com.atlassian.servicedesk.project.internal.rest.customerchannels.CustomerChannelsService;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="customerchannels/{projectKey}")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class CustomerChannelsResource {
    private final JiraAuthenticationContext authenticationContext;
    private final ServiceDeskManager serviceDeskManager;
    private final ProjectService projectService;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final PortalUrlsProvider portalUrlsProvider;
    private final ProjectUrlsProvider projectUrlProvider;
    private final PortalManager portalManager;
    private final CustomerChannelsService customerChannelsService;

    @Autowired
    public CustomerChannelsResource(JiraAuthenticationContext authenticationContext, ProjectService projectService, ServiceDeskPermissionService serviceDeskPermissionService, ServiceDeskManager serviceDeskManager, PortalUrlsProvider portalUrlsProvider, ProjectUrlsProvider projectUrlProvider, PortalManager portalManager, CustomerChannelsService customerChannelsService) {
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.serviceDeskManager = serviceDeskManager;
        this.portalUrlsProvider = portalUrlsProvider;
        this.projectUrlProvider = projectUrlProvider;
        this.portalManager = portalManager;
        this.customerChannelsService = customerChannelsService;
    }

    @GET
    public Response customerChannelsConfig(@PathParam(value="projectKey") String projectKey) {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        Project project = projectResult.getProject();
        io.atlassian.fugue.Either customerChannelsResponseResult = Steps.begin((io.atlassian.fugue.Either)this.portalManager.getPortalByProject(project)).then(portal -> this.serviceDeskManager.getServiceDeskForProject(project)).then((portal, serviceDesk) -> this.customerChannelsService.getEmailChannelAddressForCustomerChannelDialog((ServiceDesk)serviceDesk)).then((portal, serviceDesk, emailAddress) -> this.customerChannelsService.hasValidRequestType(project, (Portal)portal)).yield((portal, serviceDesk, emailAddress, hasValidRequestType) -> this.getResponse(user, projectKey, (Portal)portal, (ServiceDesk)serviceDesk, (String)emailAddress, (boolean)hasValidRequestType));
        return ((Response.ResponseBuilder)customerChannelsResponseResult.fold(error -> Response.status((int)error.getHttpStatusCode()).entity((Object)error.getMessage().getMessage()), Response::ok)).build();
    }

    private CustomerChannelsResponse getResponse(ApplicationUser user, String projectKey, Portal portal, ServiceDesk serviceDesk, String emailAddress, boolean hasValidRequestType) {
        boolean isAgentAdmin;
        io.atlassian.fugue.Either isAgentAdminResult = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user, serviceDesk));
        boolean canManageAddress = isAgentAdmin = ((Boolean)isAgentAdminResult.right().getOrElse((Object)false)).booleanValue();
        PortalUrls portalUrls = this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE);
        String portalUrl = portalUrls.portal().toString();
        String emailSettingsUrl = "";
        if (isAgentAdmin) {
            ProjectUrls projectUrls = this.projectUrlProvider.getUrls(projectKey, ProjectUrlsProvider.UrlMode.ABSOLUTE);
            emailSettingsUrl = projectUrls.emailSettings().toString();
        }
        return new CustomerChannelsResponse(portalUrl, emailSettingsUrl, !emailAddress.isEmpty(), emailAddress, canManageAddress, hasValidRequestType);
    }
}

