/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.rest;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.webfragments.WebInterfaceBeanService;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContextProvider;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="pages/sla/{projectKey}")
public class SlaPageResource {
    private final WebInterfaceBeanService webInterfaceBeanService;
    private final ServiceDeskProjectContextProvider serviceDeskProjectContextProvider;

    @Autowired
    public SlaPageResource(WebInterfaceBeanService webInterfaceBeanService, ServiceDeskProjectContextProvider serviceDeskProjectContextProvider) {
        this.webInterfaceBeanService = webInterfaceBeanService;
        this.serviceDeskProjectContextProvider = serviceDeskProjectContextProvider;
    }

    @GET
    @Path(value="nav")
    public Response getNav(@PathParam(value="projectKey") String projectKey) {
        Either<AnError, ServiceDeskProjectContext> projectContextEither = this.serviceDeskProjectContextProvider.getContext(projectKey);
        if (projectContextEither.isRight()) {
            ServiceDeskProjectContext context = (ServiceDeskProjectContext)projectContextEither.right().get();
            List response = this.webInterfaceBeanService.getWebSections("sd-jira-admin-sla-subnav", context.toMap());
            return Response.ok((Object)response).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

