/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseLink;
import com.atlassian.servicedesk.internal.api.knowledgebase.ConfluenceKnowledgeBaseService;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.internal.api.rest.responses.kb.ConfluenceKBLinkResponse;
import com.atlassian.servicedesk.project.internal.rest.response.KnowledgeBasePrimaryNavDataResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/knowledge-base")
public class KnowledgeBasePrimaryNavResource {
    private final OnBoardingPropertiesService onBoardingPropertiesService;
    private final JiraAuthenticationContext authenticationContext;
    private final ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService;
    private final RestResponseHelper restResponseHelper;
    private final ProjectService projectService;
    private final UserFactory userFactory;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public KnowledgeBasePrimaryNavResource(OnBoardingPropertiesService onBoardingPropertiesService, JiraAuthenticationContext authenticationContext, ConfluenceKnowledgeBaseService confluenceKnowledgeBaseService, RestResponseHelper restResponseHelper, ProjectService projectService, UserFactory userFactory, ErrorResultHelper errorResultHelper) {
        this.onBoardingPropertiesService = onBoardingPropertiesService;
        this.authenticationContext = authenticationContext;
        this.confluenceKnowledgeBaseService = confluenceKnowledgeBaseService;
        this.restResponseHelper = restResponseHelper;
        this.projectService = projectService;
        this.userFactory = userFactory;
        this.errorResultHelper = errorResultHelper;
    }

    @GET
    public Response getKnowledgeBasePrimaryNavData() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        Boolean isDismissed = this.onBoardingPropertiesService.isKnowledgeBasePrimaryNavDismissed(user);
        KnowledgeBasePrimaryNavDataResponse response = new KnowledgeBasePrimaryNavDataResponse(isDismissed);
        return Response.ok((Object)response).build();
    }

    @POST
    @Path(value="/dismiss")
    public Response dismissKnowledgeBasePrimaryNav() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.onBoardingPropertiesService.dismissKnowledgeBasePrimaryNav(user);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/restore")
    public Response restoreKnowledgeBasePrimaryNav() {
        ApplicationUser user = this.authenticationContext.getLoggedInUser();
        if (user == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        this.onBoardingPropertiesService.restoreKnowledgeBasePrimaryNav(user);
        return Response.noContent().build();
    }

    @POST
    @Path(value="/create-space-for-project/{projectKey}")
    public Response createSpaceForProject(@PathParam(value="projectKey") String projectKey) {
        return (Response)Steps.begin(this.getProjectByKey(projectKey)).then(project -> StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then((project, user) -> this.confluenceKnowledgeBaseService.generateAndLinkSpace(user, project)).yield((project, user, kbLink) -> kbLink).fold(arg_0 -> ((RestResponseHelper)this.restResponseHelper).anErrorToResponse(arg_0), linkedSpace -> Response.ok((Object)ConfluenceKBLinkResponse.toConfluenceKBLinkResponse((ConfluenceKnowledgeBaseLink)linkedSpace)).build());
    }

    private io.atlassian.fugue.Either<AnError, Project> getProjectByKey(String projectKey) {
        ProjectService.GetProjectResult getProjectResult = this.projectService.getProjectByKey(projectKey);
        io.atlassian.fugue.Either projectEither = !getProjectResult.isValid() ? io.atlassian.fugue.Either.left((Object)this.errorResultHelper.notFound404("sd.error.project.not.found", new Object[]{projectKey}).build()) : io.atlassian.fugue.Either.right((Object)getProjectResult.getProject());
        return projectEither;
    }
}

