/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.requesttypes;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.web.api.WebItem;
import com.atlassian.plugin.web.api.model.WebFragmentBuilder;
import com.atlassian.plugin.web.api.provider.WebItemProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.internal.api.requesttype.RequestTypeInternalService;
import com.atlassian.servicedesk.project.internal.util.PluginHelper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HiddenGroupItemProvider
implements WebItemProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final RequestTypeInternalService requestTypeInternalService;
    private final ProjectUrlsProvider projectUrlProvider;

    @Autowired
    public HiddenGroupItemProvider(JiraAuthenticationContext jiraAuthenticationContext, RequestTypeInternalService requestTypeInternalService, ProjectUrlsProvider projectUrlProvider) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.requestTypeInternalService = requestTypeInternalService;
        this.projectUrlProvider = projectUrlProvider;
    }

    public Iterable<WebItem> getItems(Map<String, Object> context) {
        ArrayList items = Lists.newArrayList();
        Project project = (Project)context.get("project");
        if (project == null) {
            return items;
        }
        ProjectUrls projectUrls = this.projectUrlProvider.getUrls(project.getKey(), ProjectUrlsProvider.UrlMode.RELATIVE);
        WebItem hiddenItem = new WebFragmentBuilder(PluginHelper.completeKeyFor("request-type-nav-hidden"), 10).label(this.jiraAuthenticationContext.getI18nHelper().getText("sd.admin.request.edit.groups.hidden")).addParam("pageId", "group").addParam("entityId", "hidden").styleClass("sd-hidden-group").addParam("count", this.getHiddenGroupItemCount(project)).webItem("").url(projectUrls.requestTypeSettings("hidden").toASCIIString()).build();
        items.add(hiddenItem);
        return items;
    }

    private String getHiddenGroupItemCount(Project project) {
        return (String)this.requestTypeInternalService.countHiddenRequestTypes(project).fold(error -> "0", count -> count + "");
    }
}

