/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.permissions;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionsUtil {
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ProjectService projectService;
    private final ServiceDeskService serviceDeskService;
    private final PermissionManager permissionManager;

    @Autowired
    public PermissionsUtil(ServiceDeskPermissionService serviceDeskPermissionService, ProjectService projectService, ServiceDeskService serviceDeskService, PermissionManager permissionManager) {
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.projectService = projectService;
        this.serviceDeskService = serviceDeskService;
        this.permissionManager = permissionManager;
    }

    public boolean isAgentForProject(@Nullable ApplicationUser user, String projectKey) {
        if (user == null) {
            return false;
        }
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return false;
        }
        Project project = projectResult.getProject();
        io.atlassian.fugue.Either serviceDeskResult = StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(user, project));
        if (serviceDeskResult.isLeft()) {
            return false;
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskResult.right().get();
        io.atlassian.fugue.Either isAgent = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user, serviceDesk));
        return (Boolean)isAgent.right().getOrElse((Object)false);
    }

    public boolean hasBrowseProjectPermission(@Nullable ApplicationUser user, String projectKey) {
        return this.hasPermissionForProject(user, ProjectPermissions.BROWSE_PROJECTS, projectKey);
    }

    public boolean hasPermissionForProject(@Nullable ApplicationUser user, ProjectPermissionKey permissionKey, String projectKey) {
        if (user == null) {
            return false;
        }
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return false;
        }
        Project project = projectResult.getProject();
        return this.permissionManager.hasPermission(permissionKey, project, user);
    }
}

