/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.context;

import com.atlassian.fugue.Either;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorCollectionHelper;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContextImpl;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContextProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServiceDeskProjectContextProviderImpl
implements ServiceDeskProjectContextProvider {
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final ProjectService projectService;
    private final ServiceDeskManager serviceDeskManager;
    private final PortalManager portalManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final ProjectUrlsProvider projectUrlProvider;
    private final ErrorResultHelper errorHelper;

    @Autowired
    public ServiceDeskProjectContextProviderImpl(JiraAuthenticationContext jiraAuthenticationContext, ProjectUrlsProvider projectUrlProvider, ServiceDeskPermissionService serviceDeskPermissionService, ProjectService projectService, ServiceDeskManager serviceDeskManager, PortalManager portalManager, ErrorResultHelper errorHelper) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.projectUrlProvider = projectUrlProvider;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.projectService = projectService;
        this.serviceDeskManager = serviceDeskManager;
        this.portalManager = portalManager;
        this.errorHelper = errorHelper;
    }

    @Override
    public io.atlassian.fugue.Either<AnError, ServiceDeskProjectContext> getContext(String projectKey) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKey(user, projectKey);
        if (!projectResult.isValid()) {
            return StepsConverters.newerEither((Either)ErrorCollectionHelper.error((ErrorCollection)projectResult.getErrorCollection()));
        }
        Project project = projectResult.getProject();
        io.atlassian.fugue.Either serviceDeskResult = this.serviceDeskManager.getServiceDeskForProject(project);
        if (serviceDeskResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)serviceDeskResult.left().get());
        }
        ServiceDesk serviceDesk = (ServiceDesk)serviceDeskResult.right().get();
        io.atlassian.fugue.Either isAgentResult = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAgent(user, serviceDesk));
        Boolean isAgent = (Boolean)isAgentResult.right().getOrElse((Object)false);
        io.atlassian.fugue.Either isAdminResult = StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user, serviceDesk));
        Boolean isAdmin = (Boolean)isAdminResult.right().getOrElse((Object)false);
        io.atlassian.fugue.Either portalResult = this.portalManager.getPortalByProject(project);
        if (portalResult.isLeft()) {
            return io.atlassian.fugue.Either.left((Object)portalResult.left().get());
        }
        Portal portal = (Portal)portalResult.right().get();
        ProjectUrls projectUrls = this.projectUrlProvider.getUrls(projectKey, ProjectUrlsProvider.UrlMode.WITHOUT_CONTEXT);
        ServiceDeskProjectContextImpl context = new ServiceDeskProjectContextImpl(user, projectUrls, project, serviceDesk, portal, isAdmin, isAgent);
        return io.atlassian.fugue.Either.right((Object)context);
    }
}

