/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.context;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.project.ProjectUrls;
import com.atlassian.servicedesk.internal.api.webfragments.ConnectContextKeyMappings;
import com.atlassian.servicedesk.project.internal.context.ServiceDeskProjectContext;
import io.atlassian.fugue.Effect;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;

public class ServiceDeskProjectContextImpl
implements ServiceDeskProjectContext {
    private final Option<ApplicationUser> user;
    private final Project project;
    private final ServiceDesk serviceDesk;
    private final Portal portal;
    private final boolean isAdmin;
    private final boolean isAgent;
    private final ProjectUrls projectUrls;

    public ServiceDeskProjectContextImpl(ApplicationUser user, ProjectUrls projectUrls, Project project, ServiceDesk serviceDesk, Portal portal, Boolean isAdmin, Boolean isAgent) {
        this.user = Option.option((Object)user);
        this.projectUrls = projectUrls;
        this.project = project;
        this.serviceDesk = serviceDesk;
        this.portal = portal;
        this.isAdmin = isAdmin;
        this.isAgent = isAgent;
    }

    @Override
    public Option<ApplicationUser> getUser() {
        return this.user;
    }

    @Override
    public ProjectUrls getProjectUrls() {
        return this.projectUrls;
    }

    @Override
    public Project getProject() {
        return this.project;
    }

    @Override
    public ServiceDesk getServiceDesk() {
        return this.serviceDesk;
    }

    @Override
    public Portal getPortal() {
        return this.portal;
    }

    @Override
    public boolean isAgentAdmin() {
        return this.isAdmin;
    }

    @Override
    public boolean isAgent() {
        return this.isAgent;
    }

    @Override
    @TenantAware(value=TenancyScope.SUPPRESS)
    public Map<String, Object> toMap() {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        this.user.foreach((Effect)new Effect<ApplicationUser>(){

            public void apply(ApplicationUser user) {
                map.put("user", user);
            }
        });
        map.put("project", this.project);
        map.put("portal", this.portal);
        map.put("serviceDesk", this.serviceDesk);
        map.put(ConnectContextKeyMappings.SERVICE_DESK_ID.getUiKey(), this.serviceDesk.getId());
        map.put("isAdmin", this.isAdmin);
        map.put("isAgent", this.isAgent);
        map.put("projectUrls", this.projectUrls);
        return map;
    }
}

