/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.condition;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.project.internal.util.ConditionHelper;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ShowWelcomeGuideCondition
implements Condition {
    private final OnBoardingPropertiesService onBoardingPropertiesService;
    private final ConditionHelper conditionHelper;

    @Autowired
    public ShowWelcomeGuideCondition(OnBoardingPropertiesService onBoardingPropertiesService, ConditionHelper conditionHelper) {
        this.onBoardingPropertiesService = onBoardingPropertiesService;
        this.conditionHelper = conditionHelper;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        Object userObj = map.get("user");
        if (userObj != null) {
            ApplicationUser user = (ApplicationUser)userObj;
            boolean isAdminAgent = this.conditionHelper.isAgentAdmin(map);
            boolean isAgent = this.conditionHelper.isAgent(map);
            boolean isGuideDismissed = this.onBoardingPropertiesService.isWelcomeGuideDismissed(user);
            return (isAdminAgent || isAgent) && !isGuideDismissed;
        }
        return false;
    }
}

