/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.project.internal.condition;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.servicedesk.internal.api.onboarding.OnBoardingPropertiesService;
import com.atlassian.servicedesk.project.internal.util.ConditionHelper;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class ShowKnowledgeBasePrimaryNavDismissibleCondition
implements Condition {
    private final FeatureManager featureManager;
    private final ConditionHelper conditionHelper;
    private final OnBoardingPropertiesService onBoardingPropertiesService;

    @Autowired
    public ShowKnowledgeBasePrimaryNavDismissibleCondition(FeatureManager featureManager, ConditionHelper conditionHelper, OnBoardingPropertiesService onBoardingPropertiesService) {
        this.featureManager = featureManager;
        this.conditionHelper = conditionHelper;
        this.onBoardingPropertiesService = onBoardingPropertiesService;
    }

    public void init(Map<String, String> map) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> map) {
        if (!this.featureManager.isEnabled("sd.kb.primary.nav")) {
            return false;
        }
        Object userObj = map.get("user");
        if (userObj != null) {
            ApplicationUser user = (ApplicationUser)userObj;
            boolean isConfluenceLinked = this.conditionHelper.isAtLeastOneConfluenceApplicationLinked(map);
            if (isConfluenceLinked) {
                return false;
            }
            boolean isDismissed = this.onBoardingPropertiesService.isKnowledgeBasePrimaryNavDismissed(user);
            return !isDismissed;
        }
        return false;
    }
}

