/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.visiblefortesting;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.servicedesk.internal.api.visiblefortesting.NotificationsBackdoor;
import com.atlassian.servicedesk.internal.api.visiblefortesting.request.NotificationBatchQueueEntryRequest;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.NotificationBatchQueueEntryResponse;
import com.atlassian.servicedesk.internal.api.visiblefortesting.response.NotificationDefaultRuleResponse;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleManager;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueDao;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntry;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntryBuilder;
import com.atlassian.servicedesk.plugins.notifications.internal.defaultrules.migration.NotificationUpgradeTaskManager;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationBatchEntryCreator;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationBatchEntryCreatorFactory;
import com.atlassian.servicedesk.plugins.notifications.internal.scheduler.NotificationBatchJobRunner;
import io.atlassian.fugue.Option;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@Internal
public class NotificationsBackdoorImpl
implements NotificationsBackdoor {
    private final NotificationBatchJobRunner notificationBatchJobRunner;
    private final NotificationBatchEntryCreatorFactory notificationBatchEntryCreatorFactory;
    private final UserManager userManager;
    private final IssueManager issueManager;
    private final DatabaseAccessor databaseAccessor;
    private final NotificationBatchQueueDao notificationBatchQueueDao;
    private final NotificationUpgradeTaskManager notificationUpgradeTaskManager;
    private final ProjectManager projectManager;
    private final NotificationDefaultRuleManager notificationRuleManager;

    @Autowired
    public NotificationsBackdoorImpl(NotificationBatchJobRunner notificationBatchJobRunner, NotificationBatchEntryCreatorFactory notificationBatchEntryCreatorFactory, UserManager userManager, IssueManager issueManager, DatabaseAccessor databaseAccessor, NotificationBatchQueueDao notificationBatchQueueDao, NotificationUpgradeTaskManager notificationUpgradeTaskManager, ProjectManager projectManager, NotificationDefaultRuleManager notificationRuleManager) {
        this.notificationBatchJobRunner = notificationBatchJobRunner;
        this.notificationBatchEntryCreatorFactory = notificationBatchEntryCreatorFactory;
        this.userManager = userManager;
        this.issueManager = issueManager;
        this.databaseAccessor = databaseAccessor;
        this.notificationBatchQueueDao = notificationBatchQueueDao;
        this.notificationUpgradeTaskManager = notificationUpgradeTaskManager;
        this.projectManager = projectManager;
        this.notificationRuleManager = notificationRuleManager;
    }

    public void flushBatchQueue() {
        this.notificationBatchJobRunner.sendBatchedMails(true);
    }

    public List<NotificationBatchQueueEntryResponse> retrieveBatchQueueEntries() {
        List entries = (List)this.databaseAccessor.run(this.notificationBatchQueueDao::fetchUnsentEntries);
        return entries.stream().map(this::transformToResponse).collect(Collectors.toList());
    }

    public void createBatchQueueEntries(NotificationBatchQueueEntryRequest ... entryRequests) {
        NotificationBatchEntryCreator creator = this.notificationBatchEntryCreatorFactory.newCreator();
        Arrays.asList(entryRequests).stream().map(this::transformToEntry).forEach(creator::addNotificationEntryToBatchList);
        creator.finalizeConsumption();
    }

    public void upgradeInstanceToCustomNotifications() {
        this.notificationUpgradeTaskManager.upgradeInstance();
    }

    public List<NotificationDefaultRuleResponse> getDefaultRules(long projectId) {
        Project project = this.projectManager.getProjectObj(Long.valueOf(projectId));
        return (List)this.notificationRuleManager.getAllSystemRules(project).fold(anError -> Collections.emptyList(), this::getNotificationRules);
    }

    private NotificationBatchQueueEntry transformToEntry(NotificationBatchQueueEntryRequest request) {
        NotificationBatchQueueEntryBuilder builder = NotificationBatchQueueEntryBuilder.newBuilder();
        builder.authorId(this.userManager.getUserByName(request.getAuthorName()).getId()).context((Option<String>)Option.option((Object)request.getContext())).eventTime(new Date()).htmlContent(request.getHtmlContent()).issueId(this.issueManager.getIssueByCurrentKey(request.getIssueKey()).getId()).projectId(request.getProjectId()).recipientId(this.userManager.getUserByName(request.getRecipientName()).getId()).textContent(request.getTextContent());
        return builder.build();
    }

    private NotificationBatchQueueEntryResponse transformToResponse(NotificationBatchQueueEntry entry) {
        return new NotificationBatchQueueEntryResponse(Long.valueOf(entry.getId()), entry.getRecipientID(), (Long)entry.getAuthorId().getOrNull(), entry.getProjectId(), (Long)entry.getIssueId().getOrNull(), entry.getHtmlContent(), entry.getTextContent(), (String)entry.getContext().getOrNull(), entry.getEventTime());
    }

    private List<NotificationDefaultRuleResponse> getNotificationRules(List<RuleSet> ruleSets) {
        return ruleSets.stream().map(ruleSet -> new NotificationDefaultRuleResponse(ruleSet.getId(), ruleSet.getName())).collect(Collectors.toList());
    }
}

