/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.internal.api.notifications.render.UnsubscribeLinkHelper;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableRenderer;
import io.atlassian.fugue.Either;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TurnOffNotificationsRenderer
implements VariableRenderer {
    private final UnsubscribeLinkHelper unsubscribeLinkHelper;
    private final ErrorResultHelper errorResultHelper;
    private final PortalManager portalManager;
    private final PortalUrlsProvider portalUrlsProvider;

    @Autowired
    public TurnOffNotificationsRenderer(UnsubscribeLinkHelper unsubscribeLinkHelper, ErrorResultHelper errorResultHelper, PortalManager portalManager, PortalUrlsProvider portalUrlsProvider) {
        this.unsubscribeLinkHelper = unsubscribeLinkHelper;
        this.errorResultHelper = errorResultHelper;
        this.portalManager = portalManager;
        this.portalUrlsProvider = portalUrlsProvider;
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        return context.getIssue().toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.content.issue.context.missing", new Object[]{context.getVariableContext().getNotificationVariable().getVariable()}).build()).flatMap(issue -> this.retrieveUnsubScribeLink((Issue)issue, context.getRecipient()));
    }

    private Either<AnError, String> retrieveUnsubScribeLink(Issue issue, ApplicationUser recipient) {
        return this.unsubscribeLinkHelper.getUnsubscribeLink(issue, recipient).toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.content.user.not.subscribed", new Object[]{recipient.getKey(), issue.getKey()}).build());
    }

    @Override
    public Either<AnError, String> renderPreview(VariableContext variableContext, NotificationPreviewContext previewContext) {
        return this.portalManager.getPortalByProjectKey(previewContext.getProject().getKey()).map(portal -> this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE).portal().toString());
    }
}

