/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.StylingVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueDescriptionVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueKeyVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueReporterVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueRequestLinkVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueRequestStatusVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueResolutionVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.IssueSummaryVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.misc.PortalNameVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.misc.RecipientNameVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.StylingRenderParams;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.HelpCenterNameRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.MessageContentRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.ServiceDeskWacUrlRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue.RequestSharedWithRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue.TurnOffNotificationsRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StylingVariableReplacementManager {
    @TenantAware(value=TenancyScope.TENANTLESS)
    @VisibleForTesting
    final Map<NotificationVariable, VariableRenderer> variableRenderers;

    @Autowired
    public StylingVariableReplacementManager(HelpCenterNameRenderer helpCenterNameRenderer, RequestSharedWithRenderer requestSharedWithRenderer, MessageContentRenderer messageContentRenderer, TurnOffNotificationsRenderer turnOffNotificationsRenderer, IssueKeyVariableRenderer issueKeyVariableRenderer, IssueSummaryVariableRenderer issueSummaryVariableRenderer, IssueDescriptionVariableRenderer issueDescriptionVariableRenderer, IssueReporterVariableRenderer issueReporterVariableRenderer, IssueResolutionVariableRenderer issueResolutionVariableRenderer, RecipientNameVariableRenderer recipientNameVariableRenderer, PortalNameVariableRenderer portalNameVariableRenderer, IssueRequestStatusVariableRenderer issueRequestStatusVariableRenderer, IssueRequestLinkVariableRenderer issueRequestLinkVariableRenderer, ServiceDeskWacUrlRenderer serviceDeskWacUrlRenderer) {
        this.variableRenderers = ImmutableMap.builder().put((Object)StylingVariable.HELP_CENTER_NAME, (Object)helpCenterNameRenderer).put((Object)StylingVariable.REQUEST_SHARED_WITH, (Object)requestSharedWithRenderer).put((Object)StylingVariable.MESSAGE_CONTENT, (Object)messageContentRenderer).put((Object)StylingVariable.REQUEST_TURN_OFF_NOTIFICATIONS, (Object)turnOffNotificationsRenderer).put((Object)ContentVariable.ISSUE_KEY, (Object)issueKeyVariableRenderer).put((Object)ContentVariable.ISSUE_SUMMARY, (Object)issueSummaryVariableRenderer).put((Object)ContentVariable.ISSUE_DESCRIPTION, (Object)issueDescriptionVariableRenderer).put((Object)ContentVariable.ISSUE_REPORTER, (Object)issueReporterVariableRenderer).put((Object)ContentVariable.ISSUE_RESOLUTION, (Object)issueResolutionVariableRenderer).put((Object)ContentVariable.RECIPIENT_NAME, (Object)recipientNameVariableRenderer).put((Object)ContentVariable.PORTAL_NAME, (Object)portalNameVariableRenderer).put((Object)ContentVariable.REQUEST_STATUS, (Object)issueRequestStatusVariableRenderer).put((Object)ContentVariable.REQUEST_URL, (Object)issueRequestLinkVariableRenderer).put((Object)StylingVariable.JSD_WAC_URL, (Object)serviceDeskWacUrlRenderer).build();
    }

    public Either<AnError, String> retrieveHtmlReplacement(VariableContext variableContext, StylingRenderParams parameters) {
        RenderContext context = RenderContext.create(variableContext, parameters, NotificationRenderFormat.HTML);
        return this.variableRenderers.get(variableContext.getNotificationVariable()).render(context);
    }

    public Either<AnError, String> retrievePlaintextReplacement(VariableContext variableContext, StylingRenderParams parameters) {
        RenderContext context = RenderContext.create(variableContext, parameters, NotificationRenderFormat.PLAIN_TEXT);
        return this.variableRenderers.get(variableContext.getNotificationVariable()).render(context);
    }

    public Either<AnError, String> retrievePreview(VariableContext variableContext, NotificationPreviewContext previewContext) {
        return this.variableRenderers.get(variableContext.getNotificationVariable()).renderPreview(variableContext, previewContext);
    }
}

