/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.fixedcontent;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationMessageContextUtils;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StylingFixedContentRenderer {
    private static final String SOY_PLUGIN_KEY = "com.atlassian.servicedesk.servicedesk-notifications-plugin:soy";
    private static final String TEMPLATE_BASE = "ServiceDesk.Internal.Notifications.Feature.OutgoingMail.Styling";
    private static final String STYLED_HTML_TEMPLATE = "ServiceDesk.Internal.Notifications.Feature.OutgoingMail.Styling.styleEmailBaseTemplate";
    private static final String STYLED_TEXT_TEMPLATE = "ServiceDesk.Internal.Notifications.Feature.OutgoingMail.Styling.styleEmailBaseTemplate_text";
    private static final String INSTANCE_BASE_URL_PARAM = "instanceBaseUrl";
    private static final String CONTENT_PARAM = "content";
    private static final String TRANSLATED_REPLY_MARKER = "translatedReplyMarker";
    private final ApplicationProperties applicationProperties;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final ServiceDeskManager serviceDeskManager;
    private final NotificationMessageContextUtils notificationMessageContextUtils;
    private final I18nHelper.BeanFactory i18nFactory;

    @Autowired
    public StylingFixedContentRenderer(ApplicationProperties applicationProperties, SoyTemplateRenderer soyTemplateRenderer, ServiceDeskManager serviceDeskManager, NotificationMessageContextUtils notificationMessageContextUtils, I18nHelper.BeanFactory i18nFactory) {
        this.applicationProperties = applicationProperties;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.serviceDeskManager = serviceDeskManager;
        this.notificationMessageContextUtils = notificationMessageContextUtils;
        this.i18nFactory = i18nFactory;
    }

    public String addContentToHtmlTemplate(Locale locale, String content, boolean addReplyAbove) {
        return this.addContentToTemplate(STYLED_HTML_TEMPLATE, locale, content, addReplyAbove);
    }

    public String addContentToPlainTextTemplate(Locale locale, String content, boolean addReplyAbove) {
        return this.addContentToTemplate(STYLED_TEXT_TEMPLATE, locale, content, addReplyAbove);
    }

    public boolean shouldAddReplyAboveMarkerForProject(Project project) {
        return (Boolean)this.serviceDeskManager.getServiceDeskForProject(project).map(arg_0 -> ((NotificationMessageContextUtils)this.notificationMessageContextUtils).isMarkerInsertionEnabledForServiceDesk(arg_0)).getOrElse((Object)false);
    }

    private String addContentToTemplate(String template, Locale locale, String content, boolean addReplyAbove) {
        I18nHelper i18nHelper = this.i18nFactory.getInstance(locale);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(CONTENT_PARAM, content);
        params.put(INSTANCE_BASE_URL_PARAM, this.getClientUrl());
        if (addReplyAbove) {
            params.put(TRANSLATED_REPLY_MARKER, "\u2014-\u2014-\u2014-\u2014");
        }
        return this.soyTemplateRenderer.render(SOY_PLUGIN_KEY, template, params);
    }

    private String getClientUrl() {
        return StringUtils.removeEnd((String)this.applicationProperties.getString("jira.baseurl"), (String)"/");
    }
}

