/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.styling;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.StylingVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.ReplacementInformation;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableReplacementUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.StylingRenderParams;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.fixedcontent.StylingPreviewFixedLayoutRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.StylingVariableReplacementManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StylingRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(StylingRenderer.class);
    private final StylingVariableReplacementManager stylingVariableReplacementManager;
    private final StylingPreviewFixedLayoutRenderer stylingPreviewFixedLayoutRenderer;

    @Autowired
    public StylingRenderer(StylingVariableReplacementManager stylingVariableReplacementManager, StylingPreviewFixedLayoutRenderer stylingPreviewFixedLayoutRenderer) {
        this.stylingVariableReplacementManager = stylingVariableReplacementManager;
        this.stylingPreviewFixedLayoutRenderer = stylingPreviewFixedLayoutRenderer;
    }

    public Either<AnError, String> renderHtml(StylingRenderParams stylingRenderParams, String htmlTemplate) {
        return VariableReplacementUtils.replaceVariables(stylingRenderParams, htmlTemplate, VariableReplacementUtils.EXTERNAL_VARIABLE_PATTERN, this::replaceVariableHtml);
    }

    public Either<AnError, String> renderPlainText(StylingRenderParams stylingRenderParams, String plainTextTemplate) {
        return VariableReplacementUtils.replaceVariables(stylingRenderParams, plainTextTemplate, VariableReplacementUtils.EXTERNAL_VARIABLE_PATTERN, this::replaceVariablePlainText);
    }

    public Either<AnError, String> renderPreview(NotificationPreviewContext context) {
        return VariableReplacementUtils.replaceVariables(context, context.getRawContent(), VariableReplacementUtils.EXTERNAL_VARIABLE_PATTERN, this::replaceVariablePreview).map(content -> this.stylingPreviewFixedLayoutRenderer.addRequiredMessageElements(context, content.toString()));
    }

    private Either<AnError, String> replaceVariableHtml(ReplacementInformation<StylingRenderParams> replacementInformation) {
        return this.internalReplaceVariable(replacementInformation, this.stylingVariableReplacementManager::retrieveHtmlReplacement);
    }

    private Either<AnError, String> replaceVariablePlainText(ReplacementInformation<StylingRenderParams> replacementInformation) {
        return this.internalReplaceVariable(replacementInformation, this.stylingVariableReplacementManager::retrievePlaintextReplacement);
    }

    private Either<AnError, String> replaceVariablePreview(ReplacementInformation<NotificationPreviewContext> replacementInformation) {
        return this.internalReplaceVariable(replacementInformation, this.stylingVariableReplacementManager::retrievePreview);
    }

    private <Params> Either<AnError, String> internalReplaceVariable(ReplacementInformation<Params> replacementInformation, BiFunction<VariableContext, Params, Either<AnError, String>> replacementFunction) {
        String variableKey = replacementInformation.getVariableKey();
        Option renderedVariableOpt = StylingVariable.forVariable(variableKey).orElse(() -> ContentVariable.forVariable(variableKey)).flatMap(variable -> {
            VariableContext variableContext = new VariableContext((NotificationVariable)variable, replacementInformation.getCharacterBefore(), replacementInformation.getCharacterAfter());
            Either replaceResult = (Either)replacementFunction.apply(variableContext, replacementInformation.getMessage());
            replaceResult.left().forEach(anError -> LOG.error("Failed to replace variable {} - {}", (Object)variableKey, (Object)anError.getMessage().getMessage()));
            return replaceResult.toOption();
        });
        return Either.right((Object)renderedVariableOpt.getOrElse((Object)VariableReplacementUtils.createExternalVariableFormat(variableKey)));
    }
}

