/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.status;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.feature.customer.request.CustomerRequestStatusManager;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.plugins.automation.modules.internal.api.rulewhen.helper.StatusChange;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AuthorNameRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.EventTimeRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class FormattedStatusChangeRenderer
extends AbstractContentVariableRenderer {
    private static final String PARAMETER_KEY_AUTHOR_NAME = "authorName";
    private static final String PARAMETER_KEY_AUTHOR_DATE = "authorDate";
    private static final String PARAMETER_KEY_STATUS = "status";
    private static final String PARAMETER_KEY_IS_RESOLVED = "isResolved";
    private static final String TEMPLATE_HTML = "ServiceDesk.Internal.Notifications.Feature.Variables.Status.Formatted.html";
    private static final String TEMPLATE_TEXT = "ServiceDesk.Internal.Notifications.Feature.Variables.Status.Formatted.text";
    private final CustomerRequestStatusManager customerRequestStatusManager;
    private final AuthorNameRenderer authorNameRenderer;
    private final EventTimeRenderer eventTimeRenderer;
    private final SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    public FormattedStatusChangeRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory, CustomerRequestStatusManager customerRequestStatusManager, AuthorNameRenderer authorNameRenderer, EventTimeRenderer eventTimeRenderer, SoyTemplateRenderer soyTemplateRenderer) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
        this.customerRequestStatusManager = customerRequestStatusManager;
        this.authorNameRenderer = authorNameRenderer;
        this.eventTimeRenderer = eventTimeRenderer;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        ApplicationUser recipient = context.getRecipient();
        Option<ApplicationUser> author = context.getEventAuthor();
        return Steps.begin(this.checkIssueContext(context.getIssue(), ContentVariable.REQUEST_STATUS_UPDATE)).then(issue -> this.checkStatusChangeContext(context.getStatusChange(), ContentVariable.REQUEST_STATUS_UPDATE)).then((issue, statusChange) -> this.customerRequestStatusManager.retrieveCustomerVisibleStatus(recipient, issue, statusChange.getToStatus())).yield((issue, statusChange, status) -> this.renderStatus(recipient, author, context.getEventTime(), (String)status, context.getNotificationRenderFormat(), (Issue)issue));
    }

    private Either<AnError, StatusChange> checkStatusChangeContext(Option<StatusChange> statusChangeOpt, ContentVariable notificationVariable) {
        return statusChangeOpt.toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.content.statuschange.context.missing", new Object[]{notificationVariable.getVariable()}).build());
    }

    private String renderStatus(ApplicationUser recipient, Option<ApplicationUser> author, Date eventTime, String renderedStatus, NotificationRenderFormat notificationRenderFormat, Issue issue) {
        switch (notificationRenderFormat) {
            case HTML: {
                return this.renderContent(recipient, author, eventTime, TEMPLATE_HTML, renderedStatus, issue);
            }
            case PLAIN_TEXT: {
                return this.renderContent(recipient, author, eventTime, TEMPLATE_TEXT, renderedStatus, issue);
            }
        }
        throw new UnsupportedOperationException("render format " + (Object)((Object)notificationRenderFormat) + " not supported");
    }

    private String renderContent(ApplicationUser recipient, Option<ApplicationUser> author, Date eventTime, String templateName, String renderedStatus, Issue issue) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAMETER_KEY_AUTHOR_NAME, this.authorNameRenderer.retrieveAuthorName(recipient, author));
        parameters.put(PARAMETER_KEY_AUTHOR_DATE, this.eventTimeRenderer.retrieveAuthorDate(recipient, eventTime));
        parameters.put(PARAMETER_KEY_STATUS, renderedStatus);
        parameters.put(PARAMETER_KEY_IS_RESOLVED, this.isResolved(issue));
        return this.soyTemplateRenderer.render("com.atlassian.servicedesk.servicedesk-notifications-plugin:soy", templateName, parameters);
    }

    private boolean isResolved(Issue issue) {
        return Option.option((Object)issue.getResolution()).map(IssueConstant::getNameTranslation).isDefined();
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return Either.right((Object)FormattedStatusChangeRenderer.translatedPreviewData("sd.notifications.preview.rendering.issue.status"));
    }
}

