/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.resolution;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.internal.api.util.SoyTemplateRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AuthorNameRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.EventTimeRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue.AbstractIssueResolutionVariableRenderer;
import com.google.common.annotations.VisibleForTesting;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Date;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Deprecated
@Component
public class FormattedResolutionRenderer
extends AbstractIssueResolutionVariableRenderer {
    private static final String PARAMETER_KEY_AUTHOR_NAME = "authorName";
    private static final String PARAMETER_KEY_AUTHOR_DATE = "authorDate";
    private static final String PARAMETER_KEY_RESOLUTION = "resolution";
    private static final String TEMPLATE_RESOLVED_HTML = "ServiceDesk.Internal.Notifications.Feature.Variables.Resolution.Formatted.resolvedhtml";
    private static final String TEMPLATE_RESOLVED_TEXT = "ServiceDesk.Internal.Notifications.Feature.Variables.Resolution.Formatted.resolvedtext";
    private static final String TEMPLATE_REOPENED_HTML = "ServiceDesk.Internal.Notifications.Feature.Variables.Resolution.Formatted.reopenedhtml";
    private static final String TEMPLATE_REOPENED_TEXT = "ServiceDesk.Internal.Notifications.Feature.Variables.Resolution.Formatted.reopenedtext";
    private final AuthorNameRenderer authorNameRenderer;
    private final EventTimeRenderer eventTimeRenderer;
    private final SoyTemplateRenderer soyTemplateRenderer;

    @Autowired
    public FormattedResolutionRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory, AuthorNameRenderer authorNameRenderer, EventTimeRenderer eventTimeRenderer, SoyTemplateRenderer soyTemplateRenderer) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
        this.authorNameRenderer = authorNameRenderer;
        this.eventTimeRenderer = eventTimeRenderer;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        ApplicationUser recipient = context.getRecipient();
        Option<ApplicationUser> author = context.getEventAuthor();
        return Steps.begin(this.checkIssueContext(context.getIssue(), ContentVariable.REQUEST_RESOLUTION_UPDATE)).then(issue -> this.checkResolutionChangeContext(context.getResolutionChangeType(), ContentVariable.REQUEST_RESOLUTION_UPDATE)).then((issue, resolutionchange) -> Either.right((Object)this.renderResolution(recipient, author, context.getEventTime(), context.getNotificationRenderFormat(), (Issue)issue, (FieldChangeType)resolutionchange))).yield((issue, resolutionchange, formattedResolutionChange) -> formattedResolutionChange);
    }

    private Either<AnError, FieldChangeType> checkResolutionChangeContext(Option<FieldChangeType> resolutionChange, ContentVariable notificationVariable) {
        return resolutionChange.toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.base.content.resolutionchange.context.missing", new Object[]{notificationVariable.getVariable()}).build());
    }

    @VisibleForTesting
    String renderResolution(ApplicationUser recipient, Option<ApplicationUser> author, Date eventTime, NotificationRenderFormat notificationRenderFormat, Issue issue, FieldChangeType resolutionChange) {
        return this.renderContent(recipient, author, eventTime, this.retrieveTemplateName(notificationRenderFormat, resolutionChange), issue);
    }

    private String renderContent(ApplicationUser recipient, Option<ApplicationUser> author, Date eventTime, String templateName, Issue issue) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(PARAMETER_KEY_AUTHOR_NAME, this.authorNameRenderer.retrieveAuthorName(recipient, author));
        parameters.put(PARAMETER_KEY_AUTHOR_DATE, this.eventTimeRenderer.retrieveAuthorDate(recipient, eventTime));
        this.retrieveResolution(recipient, issue).foreach(resolution -> parameters.put(PARAMETER_KEY_RESOLUTION, (String)resolution));
        return this.soyTemplateRenderer.render("com.atlassian.servicedesk.servicedesk-notifications-plugin:soy", templateName, parameters);
    }

    private String retrieveTemplateName(NotificationRenderFormat notificationRenderFormat, FieldChangeType resolutionChange) {
        switch (notificationRenderFormat) {
            case HTML: {
                return FieldChangeType.SET.equals((Object)resolutionChange) ? TEMPLATE_RESOLVED_HTML : TEMPLATE_REOPENED_HTML;
            }
            case PLAIN_TEXT: {
                return FieldChangeType.SET.equals((Object)resolutionChange) ? TEMPLATE_RESOLVED_TEXT : TEMPLATE_REOPENED_TEXT;
            }
        }
        throw new UnsupportedOperationException("render format " + (Object)((Object)notificationRenderFormat) + " not supported");
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return Either.right((Object)FormattedResolutionRenderer.translatedPreviewData("sd.notifications.preview.rendering.issue.resolution"));
    }
}

