/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.misc;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventAuthorVariableRenderer
extends AbstractContentVariableRenderer {
    @Autowired
    public EventAuthorVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        String rawInitiatorName = (String)this.checkUserContext(context.getEventAuthor(), ContentVariable.EVENT_USER_NAME).fold(e -> "", ApplicationUser::getDisplayName);
        return Either.right((Object)this.sanitisePlainTextValue(rawInitiatorName, context.getNotificationRenderFormat()));
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return Either.right((Object)EventAuthorVariableRenderer.unTranslatedPreviewData("Grizz Frix"));
    }

    private Either<AnError, ApplicationUser> checkUserContext(Option<ApplicationUser> applicationUserOpt, ContentVariable notificationVariable) {
        return (Either)applicationUserOpt.fold(() -> Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.base.content.user.context.missing", new Object[]{notificationVariable.getVariable()}).build()), Either::right);
    }
}

