/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.issue;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.AbstractContentVariableRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class IssueReporterVariableRenderer
extends AbstractContentVariableRenderer {
    @Autowired
    public IssueReporterVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory) {
        super(errorResultHelper, notificationRendererUtils, i18nBeanFactory);
    }

    @Override
    public Either<AnError, String> render(RenderContext context) {
        return this.checkIssueContext(context.getIssue(), ContentVariable.ISSUE_REPORTER).map(issue -> this.sanitisePlainTextValue(this.retrieveDisplayNameOrAnonymous(context.getRecipient(), (Option<ApplicationUser>)Option.option((Object)issue.getReporter())), context.getNotificationRenderFormat()));
    }

    @Override
    protected Either<AnError, AbstractContentVariableRenderer.VariablePreviewData> getVariablePreviewData(NotificationPreviewContext previewContext) {
        return Either.right((Object)IssueReporterVariableRenderer.unTranslatedPreviewData("Brett Kennedy"));
    }

    private String retrieveDisplayNameOrAnonymous(ApplicationUser recipient, Option<ApplicationUser> userOpt) {
        return (String)userOpt.fold(() -> this.i18nBeanFactory.getInstance(recipient).getText("sd.common.words.anonymous"), ApplicationUser::getDisplayName);
    }
}

