/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariablePreviewRenderingHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.renderers.ContentVariableRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractContentVariableRenderer
implements ContentVariableRenderer {
    protected final ErrorResultHelper errorResultHelper;
    protected final NotificationRendererUtils notificationRendererUtils;
    protected final I18nHelper.BeanFactory i18nBeanFactory;

    protected static VariablePreviewData translatedPreviewData(String value) {
        return new VariablePreviewData(value);
    }

    protected static VariablePreviewData unTranslatedPreviewData(String value) {
        return new VariablePreviewData(value, false);
    }

    public AbstractContentVariableRenderer(ErrorResultHelper errorResultHelper, NotificationRendererUtils notificationRendererUtils, I18nHelper.BeanFactory i18nBeanFactory) {
        this.errorResultHelper = errorResultHelper;
        this.notificationRendererUtils = notificationRendererUtils;
        this.i18nBeanFactory = i18nBeanFactory;
    }

    @Override
    public boolean shouldBeWikiRendered(Option<RecipientNotificationMessage> message) {
        return false;
    }

    @Override
    public Either<AnError, String> renderPlainTextValue(RenderContext renderContext) {
        return Either.left((Object)this.errorResultHelper.badRequest400("sd.notifications.base.content.variable.unsupported", new Object[0]).build());
    }

    @Override
    public Either<AnError, String> renderPreview(VariableContext variableContext, NotificationPreviewContext previewContext) {
        return VariablePreviewRenderingHelper.getPreviewDataFromContext(previewContext, variableContext, () -> this.renderPreviewFromBuiltInData(previewContext));
    }

    private Either<AnError, String> renderPreviewFromBuiltInData(NotificationPreviewContext previewContext) {
        return this.getVariablePreviewData(previewContext).map(variablePreviewData -> this.renderPreviewDataInternal((VariablePreviewData)variablePreviewData, previewContext.getLocale()));
    }

    private String renderPreviewDataInternal(VariablePreviewData variablePreviewData, Locale locale) {
        if (variablePreviewData.isI18n) {
            return this.getText(variablePreviewData.value, locale);
        }
        return variablePreviewData.value;
    }

    protected abstract Either<AnError, VariablePreviewData> getVariablePreviewData(NotificationPreviewContext var1);

    protected Either<AnError, Issue> checkIssueContext(Option<Issue> issueOpt, ContentVariable notificationVariable) {
        return (Either)issueOpt.fold(() -> Either.left((Object)this.errorResultHelper.internalServiceError500("sd.notifications.base.content.issue.context.missing", new Object[]{notificationVariable.getVariable()}).build()), Either::right);
    }

    protected String getText(String i18nKey, Locale locale) {
        return this.i18nBeanFactory.getInstance(locale).getText(i18nKey);
    }

    protected String renderFormattedFieldValue(String rawFieldValue, String fieldId, Issue issue, NotificationRenderFormat renderFormat) {
        if (renderFormat == NotificationRenderFormat.HTML) {
            return StringUtils.defaultString((String)this.notificationRendererUtils.renderFieldContentAsHtml(rawFieldValue, issue, fieldId));
        }
        return StringUtils.defaultString((String)this.notificationRendererUtils.renderFieldContentAsPlainText(rawFieldValue, issue, fieldId));
    }

    protected String sanitisePlainTextValue(String rawValue, NotificationRenderFormat renderFormat) {
        if (renderFormat == NotificationRenderFormat.HTML) {
            return StringEscapeUtils.escapeHtml((String)rawValue);
        }
        return rawValue;
    }

    protected static class VariablePreviewData {
        final boolean isI18n;
        final String value;

        public VariablePreviewData(String value) {
            this.isI18n = true;
            this.value = value;
        }

        public VariablePreviewData(String value, boolean isI18n) {
            this.isI18n = isI18n;
            this.value = value;
        }
    }
}

