/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.content;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.ReplacementInformation;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableContext;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableReplacementUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.replacement.ContentVariableReplacementManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ContentRenderer {
    private static final Logger LOG = LoggerFactory.getLogger(ContentRenderer.class);
    private final ContentVariableReplacementManager variableReplacementManager;

    @Autowired
    public ContentRenderer(ContentVariableReplacementManager variableReplacementManager) {
        this.variableReplacementManager = variableReplacementManager;
    }

    public Either<AnError, String> renderContentBeforeWikiRendering(RecipientNotificationMessage message, NotificationRenderFormat notificationRenderFormat) {
        String content = this.retrieveContentTranslationForRecipient(message);
        if (notificationRenderFormat == NotificationRenderFormat.HTML) {
            return VariableReplacementUtils.replaceVariables(message, content, VariableReplacementUtils.EXTERNAL_VARIABLE_PATTERN, this::replaceVariableAsHtmlBeforeWikiRendering);
        }
        return VariableReplacementUtils.replaceVariables(message, content, VariableReplacementUtils.EXTERNAL_VARIABLE_PATTERN, this::replaceVariableAsPlainTextBeforeWikiRendering);
    }

    public Either<AnError, String> renderContentAfterWikiRendering(RecipientNotificationMessage message, String content, NotificationRenderFormat notificationRenderFormat) {
        if (notificationRenderFormat == NotificationRenderFormat.HTML) {
            return VariableReplacementUtils.replaceVariables(message, content, VariableReplacementUtils.INTERNAL_VARIABLE_PATTERN, this::replaceVariableAsHtmlAfterWikiRendering);
        }
        return VariableReplacementUtils.replaceVariables(message, content, VariableReplacementUtils.INTERNAL_VARIABLE_PATTERN, this::replaceVariableAsPlainTextAfterWikiRendering);
    }

    public Either<AnError, String> renderPlainText(NotificationMessageMetaData metaData, String content) {
        return VariableReplacementUtils.replaceVariables(metaData, content, VariableReplacementUtils.EXTERNAL_VARIABLE_PATTERN, this::replaceVariableAsPlainText);
    }

    private String retrieveContentTranslationForRecipient(RecipientNotificationMessage recipientNotificationMessage) {
        return recipientNotificationMessage.getTranslation().getContent();
    }

    private Either<AnError, String> replaceVariableAsPlainText(ReplacementInformation<NotificationMessageMetaData> replacementInformation) {
        String variableKey = replacementInformation.getVariableKey();
        Option renderedVariableOpt = ContentVariable.forVariable(variableKey).flatMap(variable -> {
            Either<AnError, String> replaceResult = this.variableReplacementManager.retrievePlainTextReplacement((NotificationVariable)variable, (NotificationMessageMetaData)replacementInformation.getMessage());
            replaceResult.left().forEach(anError -> LOG.error("Failed to replace variable as plain text - {}", (Object)anError.getMessage().getMessage()));
            return replaceResult.toOption();
        });
        return Either.right((Object)renderedVariableOpt.getOrElse((Object)VariableReplacementUtils.createExternalVariableFormat(variableKey)));
    }

    private Either<AnError, String> replaceVariableAsHtmlBeforeWikiRendering(ReplacementInformation<RecipientNotificationMessage> replacementInformation) {
        return this.replaceVariableBeforeWikiRendering(replacementInformation, NotificationRenderFormat.HTML);
    }

    private Either<AnError, String> replaceVariableAsPlainTextBeforeWikiRendering(ReplacementInformation<RecipientNotificationMessage> replacementInformation) {
        return this.replaceVariableBeforeWikiRendering(replacementInformation, NotificationRenderFormat.PLAIN_TEXT);
    }

    private Either<AnError, String> replaceVariableAsHtmlAfterWikiRendering(ReplacementInformation<RecipientNotificationMessage> replacementInformation) {
        return this.replaceVariableAfterWikiRendering(replacementInformation, NotificationRenderFormat.HTML);
    }

    private Either<AnError, String> replaceVariableAsPlainTextAfterWikiRendering(ReplacementInformation<RecipientNotificationMessage> replacementInformation) {
        return this.replaceVariableAfterWikiRendering(replacementInformation, NotificationRenderFormat.PLAIN_TEXT);
    }

    private Either<AnError, String> replaceVariableBeforeWikiRendering(ReplacementInformation<RecipientNotificationMessage> replacementInformation, NotificationRenderFormat notificationRenderFormat) {
        String variableKey = replacementInformation.getVariableKey();
        return (Either)ContentVariable.forVariable(variableKey).fold(() -> Either.right((Object)VariableReplacementUtils.createExternalVariableFormat(variableKey)), variable -> {
            if (this.variableReplacementManager.shouldBeWikiRendered((Option<RecipientNotificationMessage>)Option.some(replacementInformation.getMessage()), (NotificationVariable)variable)) {
                return this.retrieveReplacement((NotificationVariable)variable, replacementInformation, notificationRenderFormat);
            }
            return Either.right((Object)VariableReplacementUtils.createInternalVariableFormat(variableKey));
        });
    }

    private Either<AnError, String> replaceVariableAfterWikiRendering(ReplacementInformation<RecipientNotificationMessage> replacementInformation, NotificationRenderFormat notificationRenderFormat) {
        String variableKey = replacementInformation.getVariableKey();
        return (Either)ContentVariable.forVariable(variableKey).fold(() -> Either.right((Object)VariableReplacementUtils.createExternalVariableFormat(variableKey)), variable -> this.retrieveReplacement((NotificationVariable)variable, replacementInformation, notificationRenderFormat));
    }

    private Either<AnError, String> retrieveReplacement(NotificationVariable variable, ReplacementInformation<RecipientNotificationMessage> replacementInformation, NotificationRenderFormat notificationRenderFormat) {
        VariableContext variableContext = new VariableContext(variable, replacementInformation.getCharacterBefore(), replacementInformation.getCharacterAfter());
        return this.variableReplacementManager.retrieveReplacement(variableContext, replacementInformation.getMessage(), notificationRenderFormat);
    }
}

