/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.configuration;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.VariableGroup;
import com.atlassian.servicedesk.plugins.notifications.internal.security.NotificationPermissionService;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.configuration.AvailableVariableManager;
import io.atlassian.fugue.Either;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AvailableVariableService {
    private final AvailableVariableManager availableVariableManager;
    private final NotificationPermissionService notificationPermissionService;

    @Autowired
    public AvailableVariableService(AvailableVariableManager availableVariableManager, NotificationPermissionService notificationPermissionService) {
        this.availableVariableManager = availableVariableManager;
        this.notificationPermissionService = notificationPermissionService;
    }

    public Either<AnError, List<VariableGroup>> retrieveAvailableContentVariableGroups(@Nonnull ApplicationUser user, long projectId) {
        return this.notificationPermissionService.checkProjectAdminPermission(user, projectId).flatMap(unit -> this.availableVariableManager.retrieveAvailableContentVariableGroups());
    }

    public Either<AnError, List<VariableGroup>> retrieveAvailableStylingVariableGroups(@Nonnull ApplicationUser user, long projectId) {
        return this.notificationPermissionService.checkProjectAdminPermission(user, projectId).flatMap(unit -> this.availableVariableManager.retrieveAvailableStylingVariableGroups());
    }
}

