/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.variables.configuration;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.StylingVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.VariableGroup;
import com.google.common.collect.ImmutableList;
import io.atlassian.fugue.Either;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AvailableVariableManager {
    private final I18nHelper i18nHelper;

    @Autowired
    public AvailableVariableManager(I18nHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
    }

    Either<AnError, List<VariableGroup>> retrieveAvailableContentVariableGroups() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.createVariableGroup(ContentVariable.RECIPIENT_NAME, ContentVariable.EVENT_USER_NAME));
        builder.add((Object)this.createVariableGroup(ContentVariable.ISSUE_SUMMARY, ContentVariable.ISSUE_DESCRIPTION, ContentVariable.ISSUE_KEY, ContentVariable.ISSUE_REPORTER, ContentVariable.ISSUE_RESOLUTION, ContentVariable.REQUEST_URL, ContentVariable.REQUEST_STATUS));
        builder.add((Object)this.createVariableGroup(ContentVariable.COMMENT_CONTENT));
        builder.add((Object)this.createVariableGroup(ContentVariable.PORTAL_NAME));
        return Either.right((Object)builder.build());
    }

    public Either<AnError, List<VariableGroup>> retrieveAvailableStylingVariableGroups() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)this.createVariableGroup(StylingVariable.HELP_CENTER_NAME, StylingVariable.MESSAGE_CONTENT, ContentVariable.PORTAL_NAME, ContentVariable.RECIPIENT_NAME));
        builder.add((Object)this.createVariableGroup(ContentVariable.ISSUE_DESCRIPTION, ContentVariable.ISSUE_KEY, ContentVariable.ISSUE_REPORTER, ContentVariable.ISSUE_RESOLUTION, ContentVariable.ISSUE_SUMMARY, StylingVariable.REQUEST_SHARED_WITH, ContentVariable.REQUEST_STATUS, ContentVariable.REQUEST_URL, StylingVariable.REQUEST_TURN_OFF_NOTIFICATIONS));
        builder.add((Object)this.createVariableGroup(StylingVariable.JSD_WAC_URL));
        return Either.right((Object)builder.build());
    }

    private VariableGroup createVariableGroup(NotificationVariable ... notificationVariables) {
        List<VariableGroup.Variable> variables = Arrays.stream(notificationVariables).map(this::createVariable).collect(Collectors.toList());
        return new VariableGroup(variables);
    }

    private VariableGroup.Variable createVariable(NotificationVariable notificationVariable) {
        return new VariableGroup.Variable(notificationVariable.getVariable(), this.i18nHelper.getText(notificationVariable.getNameI18nKey()), notificationVariable.getContext().getContextName());
    }
}

