/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.subject;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.lingo.languageresolution.LingoLanguageResolutionManager;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.plugins.notifications.internal.analytics.NotificationAnalyticsEventHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.ContentVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.migration.MigrationStatusChecker;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.SubjectVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.subject.EmailSubjectManager;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.ResolvedVariables;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableReplacementUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableResolutionManager;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.ContentRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class EmailSubjectManagerImpl
implements EmailSubjectManager {
    private static final String DEFAULT_REQUEST_EMAIL_SUBJECT = "${issue.key} ${issue.summary}";
    private static final int MAX_SUBJECT_TEMPLATE_LENGTH = 250;
    private static final int MAX_SUBJECT_RENDERED_LENGTH = 998;
    private static final String ISSUE_KEY_SEARCH_PATTERN = Pattern.quote(VariableReplacementUtils.createExternalVariableFormat(ContentVariable.ISSUE_KEY.getVariable()));
    private static final Pattern ISSUE_KEY_PREFIX_VALIDATION_PATTERN = Pattern.compile("[a-zA-Z0-9}]" + ISSUE_KEY_SEARCH_PATTERN);
    private static final Pattern ISSUE_KEY_SUFFIX_VALIDATION_PATTERN = Pattern.compile(ISSUE_KEY_SEARCH_PATTERN + "[a-zA-Z0-9$]");
    private static final List<ContentVariable> SUPPORTED_SUBJECT_VARIABLES = ImmutableList.builder().add((Object)ContentVariable.ISSUE_KEY).add((Object)ContentVariable.ISSUE_SUMMARY).add((Object)ContentVariable.PORTAL_NAME).build();
    private final PortalManager portalManager;
    private final I18nHelper.BeanFactory i18nFactory;
    private final I18nHelper i18nHelper;
    private final ContentRenderer contentVariableRenderer;
    private final VariableResolutionManager variableResolutionManager;
    private final ErrorResultHelper errorResultHelper;
    private final NotificationAnalyticsEventHelper notificationAnalyticsEventHelper;
    private final LingoLanguageResolutionManager lingoLanguageResolutionManager;
    private final MigrationStatusChecker migrationStatusChecker;

    @Autowired
    EmailSubjectManagerImpl(PortalManager portalManager, I18nHelper.BeanFactory i18nFactory, I18nHelper i18nHelper, ContentRenderer contentVariableRenderer, VariableResolutionManager variableResolutionManager, ErrorResultHelper errorResultHelper, NotificationAnalyticsEventHelper notificationAnalyticsEventHelper, LingoLanguageResolutionManager lingoLanguageResolutionManager, MigrationStatusChecker migrationStatusChecker) {
        this.portalManager = portalManager;
        this.i18nFactory = i18nFactory;
        this.i18nHelper = i18nHelper;
        this.contentVariableRenderer = contentVariableRenderer;
        this.variableResolutionManager = variableResolutionManager;
        this.errorResultHelper = errorResultHelper;
        this.notificationAnalyticsEventHelper = notificationAnalyticsEventHelper;
        this.lingoLanguageResolutionManager = lingoLanguageResolutionManager;
        this.migrationStatusChecker = migrationStatusChecker;
    }

    @Override
    public Either<AnError, String> renderSubjectString(NotificationMessageMetaData metaData, OutgoingEmailSettingsModel settings) {
        return (Either)metaData.getIssue().filter(issue -> StringUtils.isNotEmpty((String)issue.getKey())).fold(() -> this.buildPortalSubject(metaData.getRecipient(), metaData.getProject()), issue -> this.buildIssueSubject(metaData, settings));
    }

    @Override
    public Either<AnError, Unit> validateRequestEmailSubject(String emailSubject) {
        return this.validateVariables(emailSubject).flatMap(unit -> this.validateSubjectLength(emailSubject));
    }

    @Override
    public String getDefaultRequestEmailSubject() {
        return DEFAULT_REQUEST_EMAIL_SUBJECT;
    }

    @Override
    public List<SubjectVariable> getVariablesForEmailSubject() {
        return SUPPORTED_SUBJECT_VARIABLES.stream().map(notificationVariable -> new SubjectVariable(notificationVariable.getVariable(), this.i18nHelper.getText(notificationVariable.getNameI18nKey()))).collect(Collectors.toList());
    }

    private Either<AnError, String> buildPortalSubject(ApplicationUser recipient, Project project) {
        return this.portalManager.getPortalByProject(project).map(portal -> this.retrievePortalSubject(recipient, (Portal)portal));
    }

    private String retrievePortalSubject(ApplicationUser recipient, Portal portal) {
        return this.i18nFactory.getInstance(recipient).getText("sd.notfications.dispath.default.subject.postfix", portal.getName());
    }

    private Either<AnError, String> buildIssueSubject(NotificationMessageMetaData metaData, OutgoingEmailSettingsModel settings) {
        Either<AnError, String> subjectEither = this.contentVariableRenderer.renderPlainText(metaData, this.retrieveSubjectTemplate(metaData.getRecipient(), settings, metaData.getProject()));
        return subjectEither.map(subject -> StringUtils.left((String)subject, (int)998));
    }

    private String retrieveSubjectTemplate(ApplicationUser recipient, OutgoingEmailSettingsModel settings, Project project) {
        if (this.migrationStatusChecker.isDefaultNotificationSendingEnabled()) {
            return (String)this.lingoLanguageResolutionManager.resolveTranslationForUserFromSupplierMap(settings.getSubject(), recipient, Option.some((Object)project.getId())).fold(() -> DEFAULT_REQUEST_EMAIL_SUBJECT, LingoTranslation::getContent);
        }
        return DEFAULT_REQUEST_EMAIL_SUBJECT;
    }

    private Either<AnError, Unit> validateSubjectLength(String emailSubject) {
        if (emailSubject.length() > 250) {
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.admin.outgoing.email.subject.too.long", new Object[]{250, emailSubject.length()}).build());
        }
        return Either.right((Object)Unit.VALUE);
    }

    private Either<AnError, Unit> validateVariables(String emailSubject) {
        ResolvedVariables resolvedVariables = this.variableResolutionManager.resolveVariables(emailSubject, (Set<? extends NotificationVariable>)ImmutableSet.copyOf(SUPPORTED_SUBJECT_VARIABLES));
        Set<String> invalidVariables = resolvedVariables.getInvalidVariables();
        if (invalidVariables.size() > 0) {
            String commaSeparatedInvalidVariabled = StringUtils.join(invalidVariables, (String)", ");
            String i18nKey = invalidVariables.size() == 1 ? "sd.admin.outgoing.email.subject.invalid.variable" : "sd.admin.outgoing.email.subject.invalid.variables";
            return Either.left((Object)this.errorResultHelper.badRequest400(i18nKey, new Object[]{commaSeparatedInvalidVariabled}).build());
        }
        if (!this.doesSubjectContainIssueKey(resolvedVariables)) {
            this.notificationAnalyticsEventHelper.fireAnalyticsEvent("servicedesk.custom.notifications.simplified.ui.subject.missing.issue.key", null);
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.admin.outgoing.email.subject.no.issue.key.variable", new Object[0]).build());
        }
        if (!this.isIssueKeyPrefixAndSuffixValid(emailSubject)) {
            this.notificationAnalyticsEventHelper.fireAnalyticsEvent("servicedesk.custom.notifications.simplified.ui.subject.issue.key.invalid", null);
            return Either.left((Object)this.errorResultHelper.badRequest400("sd.admin.outgoing.email.subject.issue.key.validation.failed", new Object[0]).build());
        }
        return Either.right((Object)Unit.VALUE);
    }

    private boolean isIssueKeyPrefixAndSuffixValid(String emailSubject) {
        return !ISSUE_KEY_PREFIX_VALIDATION_PATTERN.matcher(emailSubject).find() && !ISSUE_KEY_SUFFIX_VALIDATION_PATTERN.matcher(emailSubject).find();
    }

    private boolean doesSubjectContainIssueKey(ResolvedVariables resolvedVariables) {
        return resolvedVariables.getValidVariables().contains(ContentVariable.ISSUE_KEY);
    }
}

