/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule;

import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.IfThenValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.IfValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.RuleValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ThenValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationOutcome;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.WhenValidationResult;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationValidationResult;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;

public enum NotificationValidationResultExtractor implements Function<ValidationOutcome, NotificationValidationResult>
{
    RULESET_EXTRACTOR(x$0 -> Extractor.access$800(x$0), false),
    RULE_EXTRACTOR(x$0 -> Extractor.access$700(x$0), false),
    WHEN_HANDLER_EXTRACTOR(x$0 -> Extractor.access$600(x$0), true),
    WHEN_EXTRACTOR(x$0 -> Extractor.access$500(x$0), true),
    IF_THEN_EXTRACTOR(x$0 -> Extractor.access$400(x$0), true),
    IF_CONDITION_EXTRACTOR(x$0 -> Extractor.access$300(x$0), true),
    IF_EXTRACTOR(x$0 -> Extractor.access$200(x$0), true),
    THEN_ACTION_EXTRACTOR(x$0 -> Extractor.access$100(x$0), false),
    THEN_EXTRACTOR(x$0 -> Extractor.access$000(x$0), false);

    private final Function<ValidationOutcome, Option<ValidationResult>> extractorFn;
    private final boolean generaliseFieldErrors;

    private NotificationValidationResultExtractor(Function<ValidationOutcome, Option<ValidationResult>> extractor, boolean generaliseFieldErrors) {
        this.extractorFn = extractor;
        this.generaliseFieldErrors = generaliseFieldErrors;
    }

    @Override
    public NotificationValidationResult apply(ValidationOutcome validationOutcome) {
        return (NotificationValidationResult)this.extractorFn.apply(validationOutcome).fold(() -> new NotificationValidationResult(Collections.emptyList(), new HashMap<String, List<String>>(), false), result -> new NotificationValidationResult(result.getErrors().getComponentErrors(), result.getErrors().getFieldErrors(), this.generaliseFieldErrors));
    }

    private static class Extractor {
        private Extractor() {
        }

        private static Option<ValidationResult> ruleSetValidation(ValidationOutcome validationOutcome) {
            return Option.some((Object)validationOutcome.getRuleSetValidationResult().getRuleSetValidationResult());
        }

        private static Option<ValidationResult> ruleValidation(ValidationOutcome validationOutcome) {
            return Extractor.retrieveRuleResult(validationOutcome).map(RuleValidationResult::getRuleValidationResult);
        }

        private static Option<ValidationResult> whenValidation(ValidationOutcome validationOutcome) {
            return Extractor.retrieveRuleResult(validationOutcome).map(RuleValidationResult::getWhenValidationResults).map(WhenValidationResult::getWhenValidationResult);
        }

        private static Option<ValidationResult> whenHandlerValidation(ValidationOutcome validationOutcome) {
            return Extractor.retrieveWhenResult(validationOutcome).map(WhenValidationResult::getWhenHandlerResults).flatMap(Extractor::maybeFirst);
        }

        private static Option<ValidationResult> ifThenValidation(ValidationOutcome validationOutcome) {
            return Extractor.retrieveIfThenResult(validationOutcome).map(IfThenValidationResult::getIfThenValidationResult);
        }

        private static Option<ValidationResult> ifValidation(ValidationOutcome validationOutcome) {
            return Extractor.retrieveIfThenResult(validationOutcome).map(IfThenValidationResult::getIfValidationResults).map(IfValidationResult::getIfValidationResult);
        }

        private static Option<ValidationResult> ifConditionValidation(ValidationOutcome validationOutcome) {
            return Extractor.retrieveIfThenResult(validationOutcome).map(IfThenValidationResult::getIfValidationResults).map(IfValidationResult::getIfConditionValidationResult).flatMap(Extractor::maybeFirst);
        }

        private static Option<ValidationResult> thenValidation(ValidationOutcome validationOutcome) {
            return Extractor.retrieveIfThenResult(validationOutcome).map(IfThenValidationResult::getThenValidationResults).map(ThenValidationResult::getThenValidationResult);
        }

        private static Option<ValidationResult> thenActionValidation(ValidationOutcome validationOutcome) {
            return Extractor.retrieveIfThenResult(validationOutcome).map(IfThenValidationResult::getThenValidationResults).map(ThenValidationResult::getThenActionValidationResults).flatMap(Extractor::maybeFirst);
        }

        private static Option<IfThenValidationResult> retrieveIfThenResult(ValidationOutcome validationOutcome) {
            return Extractor.retrieveRuleResult(validationOutcome).map(RuleValidationResult::getIfThenValidationResults).flatMap(Extractor::maybeFirst);
        }

        private static Option<WhenValidationResult> retrieveWhenResult(ValidationOutcome validationOutcome) {
            return Extractor.retrieveRuleResult(validationOutcome).map(RuleValidationResult::getWhenValidationResults);
        }

        private static Option<RuleValidationResult> retrieveRuleResult(ValidationOutcome validationOutcome) {
            return Extractor.maybeFirst(validationOutcome.getRuleSetValidationResult().getRuleValidationResults());
        }

        private static <E> Option<E> maybeFirst(List<E> list) {
            if (list.isEmpty()) {
                return Option.none();
            }
            return Option.some(list.get(0));
        }
    }
}

