/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.permission.ServiceDeskPermissionService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.ConfigurationData;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSetService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.WhenHandlerProvidesService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInput;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.input.RuleSetInputValidationService;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidatedRuleSet;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationOutcome;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.PermissionCheckFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlag;
import com.atlassian.servicedesk.plugins.automation.api.experimental.serviceflags.ServiceFlags;
import com.atlassian.servicedesk.plugins.notifications.internal.automation.then.SendActionValidator;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleDefaults;
import com.atlassian.servicedesk.plugins.notifications.internal.security.NotificationPermissionService;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationErrorHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRule;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRuleError;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRuleInput;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRuleManager;
import io.atlassian.fugue.Eithers;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationRuleService {
    private final NotificationPermissionService notificationPermissionService;
    private final ErrorResultHelper errorResultHelper;
    private final ServiceDeskPermissionService serviceDeskPermissionService;
    private final RuleSetInputValidationService ruleSetInputValidationService;
    private final SendActionValidator servicedeskSendNotificationThenActionValidator;
    private final NotificationRuleManager notificationRuleManager;
    private final RuleSetService ruleSetService;
    private final NotificationErrorHelper notificationErrorHelper;
    private final WhenHandlerProvidesService whenHandlerProvidesService;

    @Autowired
    public NotificationRuleService(NotificationPermissionService notificationPermissionService, ErrorResultHelper errorResultHelper, ServiceDeskPermissionService serviceDeskPermissionService, RuleSetInputValidationService ruleSetInputValidationService, SendActionValidator servicedeskSendNotificationThenActionValidator, NotificationRuleManager notificationRuleManager, RuleSetService ruleSetService, NotificationErrorHelper notificationErrorHelper, WhenHandlerProvidesService whenHandlerProvidesService) {
        this.notificationPermissionService = notificationPermissionService;
        this.errorResultHelper = errorResultHelper;
        this.serviceDeskPermissionService = serviceDeskPermissionService;
        this.ruleSetInputValidationService = ruleSetInputValidationService;
        this.servicedeskSendNotificationThenActionValidator = servicedeskSendNotificationThenActionValidator;
        this.notificationRuleManager = notificationRuleManager;
        this.ruleSetService = ruleSetService;
        this.notificationErrorHelper = notificationErrorHelper;
        this.whenHandlerProvidesService = whenHandlerProvidesService;
    }

    public io.atlassian.fugue.Either<NotificationRuleError, NotificationRule> getRuleConfiguration(CheckedUser user, ServiceDesk serviceDesk, long ruleSetId) {
        return Steps.begin(this.isUserProjectAdmin(user, serviceDesk)).then(adminUser -> this.getRuleSetById(user, ruleSetId)).then((adminUser, ruleSet) -> this.retrieveProvides(user, (RuleSet)ruleSet)).then((adminUser, ruleSet, provides) -> this.retrieveNotificationRule((RuleSet)ruleSet, (Set<String>)provides)).yield((adminUser, ruleSet, provides, notificationRule) -> notificationRule);
    }

    public io.atlassian.fugue.Either<NotificationRuleError, RuleSet> updateRuleConfiguration(CheckedUser user, ServiceDesk serviceDesk, long ruleSetId, NotificationRuleInput notificationRuleInput) {
        return Steps.begin(this.isUserProjectAdmin(user, serviceDesk)).then(admin -> this.validate(user, ruleSetId, notificationRuleInput)).then((admin, validatedRuleSet) -> this.updateRuleSet(user, ruleSetId, (ValidatedRuleSet)validatedRuleSet)).yield((adminUser, validatedRuleSet, updatedRuleSet) -> updatedRuleSet);
    }

    public io.atlassian.fugue.Either<AnError, List<NotificationRule>> getNotificationRules(ApplicationUser applicationUser, Project project) {
        return Steps.begin(this.notificationPermissionService.checkProjectAdminPermission(applicationUser, project.getId())).then(userValidated -> StepsConverters.newerEither((Either)this.ruleSetService.getActiveRuleSetsByProject(applicationUser, project))).yield((userValidated, ruleSets) -> this.applyStandardOrdering(this.filterNotificationRules((List<RuleSet>)ruleSets)));
    }

    private List<NotificationRule> applyStandardOrdering(List<NotificationRule> notificationRules) {
        ArrayList<NotificationRule> result = new ArrayList<NotificationRule>(notificationRules);
        Collections.sort(result, NotificationDefaultRuleDefaults.RULE_ORDER_COMPARATOR);
        return result;
    }

    private List<NotificationRule> filterNotificationRules(List<RuleSet> ruleSets) {
        ArrayList<NotificationRule> notificationRules = new ArrayList<NotificationRule>();
        for (RuleSet ruleSet : ruleSets) {
            this.retrieveNotificationRule(ruleSet, Collections.emptySet()).forEach(notificationRules::add);
        }
        return notificationRules;
    }

    private io.atlassian.fugue.Either<NotificationRuleError, NotificationRule> retrieveNotificationRule(RuleSet ruleSet, Set<String> effectiveProvides) {
        return this.notificationRuleManager.retrieveNotificationRule(ruleSet, effectiveProvides).leftMap(this.notificationErrorHelper::toNotificationRuleError);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, RuleSet> updateRuleSet(CheckedUser user, long ruleSetId, ValidatedRuleSet validatedRuleSet) {
        return StepsConverters.newerEither((Either)this.ruleSetService.update(user.forJIRA(), ruleSetId, validatedRuleSet, StepsConverters.olderOption((Option)Option.none()))).leftMap(this.notificationErrorHelper::toNotificationRuleError);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, ValidatedRuleSet> validate(CheckedUser user, long ruleSetId, NotificationRuleInput notificationRuleInput) {
        ConfigurationData configurationData = this.notificationRuleManager.buildDefaultRuleConfigurationData(notificationRuleInput.getThenConfigurationData());
        return Steps.begin(this.getRuleSetById(user, ruleSetId)).then(ruleSet -> this.retrieveProvides(user, (RuleSet)ruleSet)).then((ruleSet, provides) -> this.validateThenAction(user, configurationData, (Set<String>)provides)).then((ruleSet, provides, thenUnit) -> this.buildRuleSetInput((RuleSet)ruleSet, configurationData, notificationRuleInput.getRuleSetEnabled())).then((ruleSet, provides, thenUnit, ruleSetInput) -> this.validateRuleSetInput(user, (RuleSetInput)ruleSetInput)).yield((ruleSet, provides, thenUnit, ruleSetInput, validatedRuleSet) -> validatedRuleSet);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, Unit> validateThenAction(CheckedUser user, ConfigurationData configurationData, Set<String> provides) {
        ValidationResult result = this.servicedeskSendNotificationThenActionValidator.validate(user.forJIRA(), configurationData, provides);
        if (result.isPassed()) {
            return io.atlassian.fugue.Either.right((Object)Unit.Unit());
        }
        return io.atlassian.fugue.Either.left((Object)this.notificationErrorHelper.toNotificationRuleError(result));
    }

    private io.atlassian.fugue.Either<NotificationRuleError, Set<String>> retrieveProvides(CheckedUser user, RuleSet ruleSet) {
        return this.singleValueOrError(ruleSet.getRules()).flatMap(_any -> this.retrieveProvidesFromService(user, ruleSet));
    }

    private io.atlassian.fugue.Either<NotificationRuleError, Set<String>> retrieveProvidesFromService(CheckedUser user, RuleSet ruleSet) {
        ServiceFlags serviceFlags = ServiceFlags.of((ServiceFlag[])new ServiceFlag[]{PermissionCheckFlag.PERFORM_PERMISSION_CHECK});
        return StepsConverters.newerEither((Either)this.whenHandlerProvidesService.retrieveProvides(user.forJIRA(), ruleSet, serviceFlags)).leftMap(this.notificationErrorHelper::toNotificationRuleError).flatMap(this::singleValueOrError);
    }

    private <E> io.atlassian.fugue.Either<NotificationRuleError, E> singleValueOrError(List<E> list) {
        if (list.size() != 1) {
            return io.atlassian.fugue.Either.left((Object)this.notificationErrorHelper.toNotificationRuleError(this.errorResultHelper.badRequest400("sd.notifications.rule.invalid.default.rule", new Object[0]).build()));
        }
        return io.atlassian.fugue.Either.right(list.get(0));
    }

    private io.atlassian.fugue.Either<NotificationRuleError, RuleSetInput> buildRuleSetInput(RuleSet ruleSet, ConfigurationData configurationData, boolean ruleEnabled) {
        return this.notificationRuleManager.buildRuleSetInput(ruleSet, configurationData, ruleEnabled).leftMap(this.notificationErrorHelper::toNotificationRuleError);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, RuleSet> getRuleSetById(CheckedUser user, long ruleSetId) {
        return StepsConverters.newerEither((Either)this.ruleSetService.getById(user.forJIRA(), ruleSetId)).leftMap(this.notificationErrorHelper::toNotificationRuleError).flatMap(this::checkIsSystemRule);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, RuleSet> checkIsSystemRule(RuleSet ruleSet) {
        if (ruleSet.isSystemRuleSet()) {
            return io.atlassian.fugue.Either.right((Object)ruleSet);
        }
        return io.atlassian.fugue.Either.left((Object)this.notificationErrorHelper.toNotificationRuleError(this.errorResultHelper.badRequest400("sd.notifications.rule.invalid.default.rule", new Object[0]).build()));
    }

    private io.atlassian.fugue.Either<NotificationRuleError, ValidatedRuleSet> validateRuleSetInput(CheckedUser user, RuleSetInput ruleSetInput) {
        return StepsConverters.newerEither((Either)this.ruleSetInputValidationService.validate(user.forJIRA(), ruleSetInput)).leftMap(this.notificationErrorHelper::toNotificationRuleError).flatMap(this::processValidationOutcome);
    }

    private io.atlassian.fugue.Either<NotificationRuleError, ValidatedRuleSet> processValidationOutcome(ValidationOutcome validationOutcome) {
        if (validationOutcome.getRuleSetValidationResult().isPassed()) {
            return io.atlassian.fugue.Either.right((Object)validationOutcome.getValidatedRuleSet().get());
        }
        return io.atlassian.fugue.Either.left((Object)this.notificationErrorHelper.toNotificationRuleError(validationOutcome));
    }

    private io.atlassian.fugue.Either<NotificationRuleError, Boolean> isUserProjectAdmin(CheckedUser user, ServiceDesk serviceDesk) {
        return StepsConverters.newerEither((Either)this.serviceDeskPermissionService.isAdminAgent(user.forJIRA(), serviceDesk)).flatMap(isAdmin -> Eithers.cond((boolean)isAdmin, (Object)this.errorResultHelper.forbidden403("sd.notifications.rule.permission.denied", new Object[0]).build(), (Object)true)).leftMap(this.notificationErrorHelper::toNotificationRuleError);
    }
}

