/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.error.HttpStatusCode;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationOutcome;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.validation.ValidationResult;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.ValidationFailure;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.NotificationValidationResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationRuleError;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationValidationResult;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.rule.NotificationValidationResultExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationErrorHelper {
    private final RestResponseHelper restResponseHelper;
    private final I18nHelper i18nHelper;

    @Autowired
    public NotificationErrorHelper(RestResponseHelper restResponseHelper, I18nHelper i18nHelper) {
        this.restResponseHelper = restResponseHelper;
        this.i18nHelper = i18nHelper;
    }

    public NotificationRuleError toNotificationRuleError(AnError anError) {
        return new NotificationRuleError(anError);
    }

    public NotificationRuleError toNotificationRuleError(ValidationOutcome validationOutcome) {
        return new NotificationRuleError(validationOutcome);
    }

    public NotificationRuleError toNotificationRuleError(ValidationResult validationResult) {
        return new NotificationRuleError(validationResult);
    }

    public Response toResponse(NotificationRuleError notificationRuleError) {
        if (notificationRuleError.getValidationOutcome().isDefined()) {
            return this.toResponse((ValidationOutcome)notificationRuleError.getValidationOutcome().get());
        }
        if (notificationRuleError.getValidationResult().isDefined()) {
            return this.toResponse((ValidationResult)notificationRuleError.getValidationResult().get());
        }
        return this.toResponse((AnError)notificationRuleError.getAnErrorOpt().get());
    }

    public Response toResponse(ValidationResult validationResult) {
        ValidationResult.ValidationErrors errors = validationResult.getErrors();
        NotificationValidationResponse validationResponse = new NotificationValidationResponse(errors.getComponentErrors(), errors.getFieldErrors());
        return Response.status((int)HttpStatusCode.BAD_REQUEST).entity((Object)validationResponse).build();
    }

    public Response toResponse(ValidationOutcome validationOutcome) {
        List<NotificationValidationResult> validations = this.validationResults(validationOutcome);
        NotificationValidationResponse validationResponse = new NotificationValidationResponse(this.retrieveAllComponentErrors(validations), this.retrieveAllFieldErrors(validations));
        return Response.status((int)HttpStatusCode.BAD_REQUEST).entity((Object)validationResponse).build();
    }

    public Response toResponse(ValidationFailure validationFailure) {
        NotificationValidationResponse validationResponse = new NotificationValidationResponse(Collections.emptyList(), validationFailure.getFieldErrors());
        return Response.status((int)HttpStatusCode.BAD_REQUEST).entity((Object)validationResponse).build();
    }

    public Response toResponse(AnError anError) {
        return this.restResponseHelper.anErrorToResponse(anError);
    }

    private Map<String, List<String>> retrieveAllFieldErrors(List<NotificationValidationResult> validations) {
        return validations.stream().filter(result -> !result.isGeneraliseFieldErrors()).map(NotificationValidationResult::getFieldErrors).reduce(new HashMap(), this::concatFieldListsReducer);
    }

    private Map<String, List<String>> concatFieldListsReducer(Map<String, List<String>> idMap, Map<String, List<String>> accMap) {
        for (String key : idMap.keySet()) {
            if (accMap.containsKey(key)) {
                accMap.get(key).addAll((Collection<String>)idMap.get(key));
                continue;
            }
            accMap.put(key, idMap.get(key));
        }
        return accMap;
    }

    private List<String> retrieveAllComponentErrors(List<NotificationValidationResult> validations) {
        return validations.stream().map(this::retrieveComponentErrors).flatMap(Collection::stream).distinct().collect(Collectors.toList());
    }

    private List<String> retrieveComponentErrors(NotificationValidationResult notificationValidationResult) {
        ArrayList<String> componentErrors = new ArrayList<String>();
        componentErrors.addAll(notificationValidationResult.getComponentErrors());
        if (notificationValidationResult.isGeneraliseFieldErrors() && notificationValidationResult.getFieldErrors().size() > 0) {
            componentErrors.add(this.i18nHelper.getText("sd.notification.default.rule.hidden.component.error"));
        }
        return componentErrors;
    }

    private List<NotificationValidationResult> validationResults(ValidationOutcome validationOutcome) {
        return Arrays.stream(NotificationValidationResultExtractor.values()).map(extractor -> extractor.apply(validationOutcome)).collect(Collectors.toList());
    }
}

