/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.simpleui.preview;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.lingo.languageresolution.LingoLanguageResolutionManager;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.StylingPreviewMessageField;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsManager;
import com.atlassian.servicedesk.plugins.notifications.internal.preview.PreviewSubjectRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.StylingTestEmailUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderMode;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationTestEmailManager {
    private final StylingTestEmailUtils stylingTestEmailUtils;
    private final OutgoingEmailSettingsManager outgoingEmailSettingsManager;
    private final ServiceDeskManager serviceDeskManager;
    private final PreviewSubjectRenderer previewSubjectRenderer;
    private final LingoLanguageResolutionManager lingoLanguageResolutionManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    NotificationTestEmailManager(StylingTestEmailUtils stylingTestEmailUtils, OutgoingEmailSettingsManager outgoingEmailSettingsManager, ServiceDeskManager serviceDeskManager, PreviewSubjectRenderer previewSubjectRenderer, LingoLanguageResolutionManager lingoLanguageResolutionManager, ErrorResultHelper errorResultHelper) {
        this.stylingTestEmailUtils = stylingTestEmailUtils;
        this.outgoingEmailSettingsManager = outgoingEmailSettingsManager;
        this.serviceDeskManager = serviceDeskManager;
        this.previewSubjectRenderer = previewSubjectRenderer;
        this.lingoLanguageResolutionManager = lingoLanguageResolutionManager;
        this.errorResultHelper = errorResultHelper;
    }

    Either<AnError, String> sendHtmlTestEmail(NotificationPreviewContext context, String renderedHtmlContent, String renderedPlainTextContent) {
        return Steps.begin(this.renderSubject(context)).then(subject -> this.buildHtmlEmailBody(context, renderedHtmlContent, renderedPlainTextContent)).then((subject, messageBody) -> this.sendTestEmail(context, (String)subject, (ServiceDeskEmailBody)messageBody)).yield((settings, messageBody, toAddress) -> toAddress);
    }

    Either<AnError, String> sendPlainTextTestEmail(NotificationPreviewContext context, String renderedPlainTextContent) {
        return Steps.begin(this.renderSubject(context)).then(subject -> this.buildPlainTextEmailBody(renderedPlainTextContent)).then((subject, messageBody) -> this.sendTestEmail(context, (String)subject, (ServiceDeskEmailBody)messageBody)).yield((settings, messageBody, toAddress) -> toAddress);
    }

    private Either<AnError, String> renderSubject(NotificationPreviewContext context) {
        return this.serviceDeskManager.getServiceDeskForProject(context.getProject()).flatMap(this.outgoingEmailSettingsManager::retrieveSettings).flatMap(settings -> this.resolveTranslation(settings.getSubject(), context.getLocale(), context.getProject().getId())).flatMap(subjectContent -> this.buildRenderedSubject(context, (String)subjectContent));
    }

    private Either<AnError, String> buildRenderedSubject(NotificationPreviewContext context, String subjectTemplate) {
        NotificationPreviewContext subjectContext = this.toSubjectPreviewContext(context, subjectTemplate);
        return this.previewSubjectRenderer.renderSubject(context.getPreviewingUser().forJIRA(), subjectContext);
    }

    private Either<AnError, String> sendTestEmail(NotificationPreviewContext context, String subject, ServiceDeskEmailBody messageBody) {
        return this.stylingTestEmailUtils.sendTestEmail(context.getProject(), context.getPreviewingUser(), messageBody, subject);
    }

    private Either<AnError, ServiceDeskEmailBody> buildHtmlEmailBody(NotificationPreviewContext context, String html, String plainText) {
        return this.stylingTestEmailUtils.renderHtmlBody(context.getPreviewingUser().forJIRA(), html, plainText);
    }

    private Either<AnError, ServiceDeskEmailBody> buildPlainTextEmailBody(String plainText) {
        return this.stylingTestEmailUtils.renderPlainTextBody(plainText);
    }

    private NotificationPreviewContext toSubjectPreviewContext(NotificationPreviewContext context, String subjectTemplate) {
        return NotificationPreviewContext.newBuilder(context).withRawContent(subjectTemplate).withRenderMode(RenderMode.STYLING).withRenderFormat(NotificationRenderFormat.PLAIN_TEXT).withStylingPreviewMessageField(StylingPreviewMessageField.SUBJECT).build();
    }

    private Either<AnError, String> resolveTranslation(Map<Locale, Supplier<String>> translations, Locale locale, long projectId) {
        return this.lingoLanguageResolutionManager.resolveTranslationForLocaleFromSupplierMap(translations, locale, Option.some((Object)projectId)).map(LingoTranslation::getContent).toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.preview.translation.not.available", new Object[0]).build());
    }
}

