/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.simpleui.preview;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.api.commons.result.Unit;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.api.ServiceDeskService;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsService;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.preview.NotificationPreviewManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationPreviewService {
    private final OutgoingEmailSettingsService outgoingEmailSettingsService;
    private final ServiceDeskService serviceDeskService;
    private final NotificationPreviewManager notificationPreviewManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public NotificationPreviewService(OutgoingEmailSettingsService outgoingEmailSettingsService, ServiceDeskService serviceDeskService, NotificationPreviewManager notificationPreviewManager, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, ErrorResultHelper errorResultHelper) {
        this.outgoingEmailSettingsService = outgoingEmailSettingsService;
        this.serviceDeskService = serviceDeskService;
        this.notificationPreviewManager = notificationPreviewManager;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.errorResultHelper = errorResultHelper;
    }

    public io.atlassian.fugue.Either<AnError, String> renderPreview(CheckedUser checkedUser, NotificationPreviewContext notificationPreviewContext) {
        return Steps.begin(this.checkAdministerPermission(checkedUser, notificationPreviewContext.getProject())).then(auth -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(checkedUser.forJIRA(), notificationPreviewContext.getProject()))).then((auth, serviceDesk) -> this.outgoingEmailSettingsService.retrieveSettings(checkedUser, (ServiceDesk)serviceDesk)).then((auth, serviceDesk, settings) -> this.notificationPreviewManager.renderPreview(notificationPreviewContext, (OutgoingEmailSettingsModel)settings)).yield((auth, serviceDesk, settings, renderedPreview) -> renderedPreview);
    }

    public io.atlassian.fugue.Either<AnError, String> sendTestEmail(CheckedUser checkedUser, NotificationPreviewContext notificationPreviewContext) {
        return Steps.begin(this.checkAdministerPermission(checkedUser, notificationPreviewContext.getProject())).then(auth -> StepsConverters.newerEither((Either)this.serviceDeskService.getServiceDeskForProject(checkedUser.forJIRA(), notificationPreviewContext.getProject()))).then((auth, serviceDesk) -> this.outgoingEmailSettingsService.retrieveSettings(checkedUser, (ServiceDesk)serviceDesk)).then((auth, serviceDesk, settings) -> this.notificationPreviewManager.sendTestEmail(notificationPreviewContext, (OutgoingEmailSettingsModel)settings)).yield((auth, serviceDesk, settings, recipientAddress) -> recipientAddress);
    }

    private io.atlassian.fugue.Either<AnError, Unit> checkAdministerPermission(CheckedUser checkedUser, Project project) {
        if (!this.serviceDeskLicenseAndPermissionService.canAdministerServiceDesk((SDUser)checkedUser, project)) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.forbidden403("sd.admin.servicedesk.common.error.permissions", new Object[0]).build());
        }
        return io.atlassian.fugue.Either.right((Object)Unit.UNIT);
    }
}

