/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.simpleui.preview;

import com.atlassian.botocss.Botocss;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.StylingVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.CustomPreviewData;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.StylingPreviewMessageField;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationContentRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.preview.NotificationTestEmailManager;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderMode;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.StylingRenderer;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationPreviewManager {
    private final NotificationContentRenderer notificationContentRenderer;
    private final StylingRenderer stylingRenderer;
    private final FeatureManager featureManager;
    private final NotificationTestEmailManager notificationTestEmailManager;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    NotificationPreviewManager(NotificationContentRenderer notificationContentRenderer, StylingRenderer stylingRenderer, FeatureManager featureManager, NotificationTestEmailManager notificationTestEmailManager, ErrorResultHelper errorResultHelper) {
        this.notificationContentRenderer = notificationContentRenderer;
        this.stylingRenderer = stylingRenderer;
        this.featureManager = featureManager;
        this.notificationTestEmailManager = notificationTestEmailManager;
        this.errorResultHelper = errorResultHelper;
    }

    Either<AnError, String> renderPreview(NotificationPreviewContext notificationPreviewContext, OutgoingEmailSettingsModel outgoingEmailSettingsModel) {
        if (this.featureManager.isEnabled("sd.custom.email.notifications.styling")) {
            return this.notificationContentRenderer.renderPreviewContent(notificationPreviewContext).flatMap(renderedContent -> this.renderStylingPreview(notificationPreviewContext, outgoingEmailSettingsModel, (String)renderedContent));
        }
        return this.notificationContentRenderer.renderPreviewContent(notificationPreviewContext);
    }

    Either<AnError, String> sendTestEmail(NotificationPreviewContext context, OutgoingEmailSettingsModel outgoingEmailSettingsModel) {
        if (context.getRenderFormat() == NotificationRenderFormat.HTML) {
            return this.sendHtmlTextTestEmail(context, outgoingEmailSettingsModel);
        }
        return this.sendPlainTextTestEmail(context, outgoingEmailSettingsModel);
    }

    private Either<AnError, String> sendPlainTextTestEmail(NotificationPreviewContext context, OutgoingEmailSettingsModel outgoingEmailSettingsModel) {
        return Steps.begin(this.renderPreview(context, outgoingEmailSettingsModel)).then(renderedContent -> this.notificationTestEmailManager.sendPlainTextTestEmail(context, (String)renderedContent)).yield((renderedContent, toAddress) -> toAddress);
    }

    private Either<AnError, String> sendHtmlTextTestEmail(NotificationPreviewContext context, OutgoingEmailSettingsModel outgoingEmailSettingsModel) {
        return Steps.begin(this.renderPreview(context, outgoingEmailSettingsModel)).then(renderedHtml -> this.renderPreview(this.toPlainTextPreviewContext(context), outgoingEmailSettingsModel)).then((renderedHtml, renderedPlainText) -> this.notificationTestEmailManager.sendHtmlTestEmail(context, (String)renderedHtml, (String)renderedPlainText)).yield((renderedHtml, renderedPlainText, toAddress) -> toAddress);
    }

    private Either<AnError, String> renderStylingPreview(NotificationPreviewContext notificationPreviewContext, OutgoingEmailSettingsModel outgoingEmailSettingsModel, String renderedContent) {
        return Steps.begin(this.buildStylingPreviewContext(notificationPreviewContext, outgoingEmailSettingsModel, renderedContent)).then(stylingPreviewContext -> this.stylingRenderer.renderPreview((NotificationPreviewContext)stylingPreviewContext)).yield((stylingPreviewContext, content) -> this.markupPreviewContent((NotificationPreviewContext)stylingPreviewContext, (String)content));
    }

    private String markupPreviewContent(NotificationPreviewContext stylingPreviewContext, String content) {
        if (stylingPreviewContext.getRenderFormat() == NotificationRenderFormat.HTML) {
            return Botocss.inject((String)content, (String[])new String[]{(String)stylingPreviewContext.getCss().getOrElse((Object)"")});
        }
        return content;
    }

    private NotificationPreviewContext toPlainTextPreviewContext(NotificationPreviewContext contentPreviewContext) {
        return NotificationPreviewContext.newBuilder(contentPreviewContext).withRenderFormat(NotificationRenderFormat.PLAIN_TEXT).build();
    }

    private Either<AnError, NotificationPreviewContext> buildStylingPreviewContext(NotificationPreviewContext contentPreviewContext, OutgoingEmailSettingsModel outgoingEmailSettingsModel, String renderedContent) {
        CustomPreviewData customPreviewData = this.toCustomPreviewData(contentPreviewContext.getRenderFormat(), renderedContent);
        return Steps.begin(this.resolveBaseTemplate(contentPreviewContext, outgoingEmailSettingsModel)).then(template -> this.resolveTranslation(outgoingEmailSettingsModel.getCss(), contentPreviewContext.getLocale())).yield((template, css) -> NotificationPreviewContext.newBuilder(contentPreviewContext).withRawContent((String)template).withCss((String)css).withRenderMode(RenderMode.STYLING).withStylingPreviewMessageField(StylingPreviewMessageField.BODY).withVariableCustomPreviewDataMap((Map<NotificationVariable, CustomPreviewData>)ImmutableMap.of((Object)StylingVariable.MESSAGE_CONTENT, (Object)customPreviewData)).build());
    }

    private Either<AnError, String> resolveBaseTemplate(NotificationPreviewContext contentPreviewContext, OutgoingEmailSettingsModel outgoingEmailSettingsModel) {
        if (contentPreviewContext.getRenderFormat() == NotificationRenderFormat.HTML) {
            return this.resolveTranslation(outgoingEmailSettingsModel.getHtmlTemplate(), contentPreviewContext.getLocale());
        }
        return this.resolveTranslation(outgoingEmailSettingsModel.getPlainTextTemplate(), contentPreviewContext.getLocale());
    }

    private CustomPreviewData toCustomPreviewData(NotificationRenderFormat notificationRenderFormat, String renderedContent) {
        return notificationRenderFormat == NotificationRenderFormat.HTML ? CustomPreviewData.htmlOnlyPreviewData(renderedContent) : CustomPreviewData.plainTextOnlyPreviewData(renderedContent);
    }

    private Either<AnError, String> resolveTranslation(Map<Locale, Supplier<String>> translations, Locale locale) {
        return Option.option(translations.get(locale)).map(Supplier::get).toRight(() -> this.errorResultHelper.internalServiceError500("sd.notifications.preview.translation.not.available", new Object[0]).build());
    }
}

