/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.scheduler;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueDao;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationBatchDispatcher;
import com.atlassian.servicedesk.plugins.notifications.internal.scheduler.NotificationBatchScheduler;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationBatchJobRunner
implements JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationBatchJobRunner.class);
    private final NotificationBatchQueueDao dao;
    private final DatabaseAccessor databaseAccessor;
    private final NotificationBatchDispatcher notificationBatchDispatcher;
    private final NotificationBatchScheduler notificationBatchScheduler;

    @Autowired
    public NotificationBatchJobRunner(NotificationBatchQueueDao dao, DatabaseAccessor databaseAccessor, NotificationBatchDispatcher notificationBatchDispatcher, NotificationBatchScheduler notificationBatchScheduler) {
        this.dao = dao;
        this.databaseAccessor = databaseAccessor;
        this.notificationBatchDispatcher = notificationBatchDispatcher;
        this.notificationBatchScheduler = notificationBatchScheduler;
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        if (!this.sendBatchedMails(false)) {
            this.notificationBatchScheduler.unscheduleBatchSending();
        }
        return JobRunnerResponse.success();
    }

    public boolean sendBatchedMails(boolean forceSend) {
        LOG.debug("Starting notification batch sending job");
        List entries = (List)this.databaseAccessor.run(this.dao::fetchUnsentEntries);
        if (!entries.isEmpty()) {
            LOG.debug("Starting Processing {} batch table entries", (Object)entries.size());
            long startTime = System.currentTimeMillis();
            List<Long> idsToUpdate = this.notificationBatchDispatcher.dispatchEmail(entries, forceSend);
            long updatedRecords = (Long)this.databaseAccessor.run(databaseConnection -> this.dao.setSendTimeStamp((Collection<Long>)idsToUpdate, (DatabaseConnection)databaseConnection));
            LOG.debug("Finished Processing {} batch table entries", (Object)updatedRecords);
            LOG.debug("Dispatch processing time: {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        LOG.debug("Finished notification batch sending job");
        return !entries.isEmpty();
    }
}

