/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.scheduler;

import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueDao;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationBatchCleanUpJobRunner
implements JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationBatchCleanUpJobRunner.class);
    private final NotificationBatchQueueDao dao;
    private final DatabaseAccessor databaseAccessor;

    @Autowired
    public NotificationBatchCleanUpJobRunner(NotificationBatchQueueDao dao, DatabaseAccessor databaseAccessor) {
        this.dao = dao;
        this.databaseAccessor = databaseAccessor;
    }

    public JobRunnerResponse runJob(@Nonnull JobRunnerRequest request) {
        LOG.debug("Starting notification batch clean up job");
        long deletedRecords = (Long)this.databaseAccessor.run(this.dao::deleteEntriesSentOverThirtyDaysAgo);
        if (deletedRecords > 0L) {
            LOG.info("Deleted {} batch table entries", (Object)deletedRecords);
        }
        LOG.debug("Finished notification batch clean up job");
        return JobRunnerResponse.success();
    }
}

