/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rest;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.lingo.manager.LingoManager;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectConfiguration;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoQueryRequestFactory;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationRecipientType;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.NotificationResourceHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.AvailableConfigurationResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.AvailableLanguageResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.RecipientTypeResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.VariableGroup;
import io.atlassian.fugue.Option;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class SendActionConfigurationResourceHelper {
    private final LingoProjectLanguageManager lingoProjectLanguageManager;
    private final LingoManager lingoManager;
    private final LingoQueryRequestFactory lingoQueryRequestFactory;
    private final I18nHelper.BeanFactory i18nFactory;
    private final NotificationResourceHelper notificationResourceHelper;

    @Autowired
    public SendActionConfigurationResourceHelper(LingoProjectLanguageManager lingoProjectLanguageManager, LingoManager lingoManager, LingoQueryRequestFactory lingoQueryRequestFactory, I18nHelper.BeanFactory i18nFactory, NotificationResourceHelper notificationResourceHelper) {
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
        this.lingoManager = lingoManager;
        this.lingoQueryRequestFactory = lingoQueryRequestFactory;
        this.i18nFactory = i18nFactory;
        this.notificationResourceHelper = notificationResourceHelper;
    }

    Response buildConfigResponse(CheckedUser user, long projectId, Set<NotificationRecipientType> availableRecipients, List<VariableGroup> variableGroups, Option<Long> lingoIdOpt) {
        LingoProjectConfiguration lingoConfiguration = this.lingoProjectLanguageManager.retrieveLingoProjectConfiguration(projectId);
        Option<Map<String, String>> contentSystemDefaults = this.retrieveSystemDefaults(lingoIdOpt, lingoConfiguration);
        List<RecipientTypeResponse> availableRecipientTypes = this.transformAvailableRecipientTypes((SDUser)user, availableRecipients);
        List<AvailableLanguageResponse> languages = this.notificationResourceHelper.transformAvailableLanguages(lingoConfiguration);
        AvailableConfigurationResponse responseEntity = new AvailableConfigurationResponse(availableRecipientTypes, variableGroups, languages, lingoConfiguration.getProjectDefaultLocale().toLanguageTag(), (Map)contentSystemDefaults.getOrNull());
        return Response.ok((Object)responseEntity).build();
    }

    private Option<Map<String, String>> retrieveSystemDefaults(Option<Long> lingoIdOpt, LingoProjectConfiguration lingoConfiguration) {
        return lingoIdOpt.map(arg_0 -> ((LingoQueryRequestFactory)this.lingoQueryRequestFactory).createLingoQueryRequest(arg_0)).flatMap(arg_0 -> ((LingoManager)this.lingoManager).retrieveLingo(arg_0)).flatMap(lingo -> this.retrieveSystemDefaultsForLingo((Lingo)lingo, lingoConfiguration));
    }

    private Option<Map<String, String>> retrieveSystemDefaultsForLingo(Lingo contentLingo, LingoProjectConfiguration lingoConfiguration) {
        return contentLingo.getSystemI18n().map(i18n -> lingoConfiguration.getLanguages().stream().collect(Collectors.toMap(language -> language.getLocale().toLanguageTag(), language -> this.getI18nTranslation((String)i18n, language.getLocale()))));
    }

    private String getI18nTranslation(String i18nKey, Locale locale) {
        return this.i18nFactory.getInstance(locale).getText(i18nKey);
    }

    private List<RecipientTypeResponse> transformAvailableRecipientTypes(SDUser user, Set<NotificationRecipientType> notificationRecipientTypes) {
        return notificationRecipientTypes.stream().map(recType -> this.createRecipientType(user, (NotificationRecipientType)((Object)recType))).collect(Collectors.toList());
    }

    private RecipientTypeResponse createRecipientType(SDUser sdUser, NotificationRecipientType notificationRecipientType) {
        return new RecipientTypeResponse(notificationRecipientType.getValue(), sdUser.i18NHelper().getText(notificationRecipientType.getNameI18nKey()), notificationRecipientType.getContext().getContextName());
    }
}

