/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rest;

import com.atlassian.fugue.Either;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.rest.RestResponseHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationContext;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.CustomPreviewData;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.StylingPreviewMessageField;
import com.atlassian.servicedesk.plugins.notifications.internal.preview.StylingPreviewHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.request.NotificationPreviewRequest;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.NotificationPreviewResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.SendPreviewEmailResponse;
import com.atlassian.servicedesk.plugins.notifications.internal.simpleui.preview.NotificationPreviewService;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderMode;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="content-preview")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class NotificationPreviewResource {
    private static final String UNDETERMINED_LANGUAGE_TAG = "und";
    private final NotificationPreviewService notificationPreviewService;
    private final ErrorResultHelper errorResultHelper;
    private final RestResponseHelper restResponseHelper;
    private final ProjectManager projectManager;
    private final UserFactory userFactory;

    @Autowired
    public NotificationPreviewResource(ErrorResultHelper errorResultHelper, NotificationPreviewService notificationPreviewService, RestResponseHelper restResponseHelper, ProjectManager projectManager, UserFactory userFactory) {
        this.errorResultHelper = errorResultHelper;
        this.notificationPreviewService = notificationPreviewService;
        this.restResponseHelper = restResponseHelper;
        this.projectManager = projectManager;
        this.userFactory = userFactory;
    }

    @POST
    public Response renderPreview(NotificationPreviewRequest notificationPreviewRequest) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.constructNotificationPreviewContext(notificationPreviewRequest, (CheckedUser)checkedUser)).then(this.notificationPreviewService::renderPreview).yield((checkedUser, previewContext, renderedPreview) -> this.toPreviewResponse((String)renderedPreview, previewContext.getRenderFormat()));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    @POST
    @Path(value="send-email")
    public Response sendTestEmail(NotificationPreviewRequest notificationPreviewRequest) {
        io.atlassian.fugue.Either result = Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.getCheckedUser())).then(checkedUser -> this.constructNotificationPreviewContext(notificationPreviewRequest, (CheckedUser)checkedUser)).then(this.notificationPreviewService::sendTestEmail).yield((checkedUser, previewContext, toAddress) -> this.toSendPreviewEmailResponse((String)toAddress));
        return this.restResponseHelper.anErrorEitherToOkResponse(result);
    }

    private NotificationPreviewResponse toPreviewResponse(String content, NotificationRenderFormat format) {
        if (format == NotificationRenderFormat.HTML) {
            return new NotificationPreviewResponse(content);
        }
        return new NotificationPreviewResponse(StylingPreviewHelper.preformatTextContent(content));
    }

    private SendPreviewEmailResponse toSendPreviewEmailResponse(String recipientAddress) {
        return new SendPreviewEmailResponse(recipientAddress);
    }

    private io.atlassian.fugue.Either<AnError, NotificationPreviewContext> constructNotificationPreviewContext(NotificationPreviewRequest notificationPreviewRequest, CheckedUser user) {
        return Steps.begin(this.getRenderFormat(notificationPreviewRequest)).then(format -> this.getNotificationContexts(notificationPreviewRequest)).then((format, notificationContexts) -> this.getLocale(notificationPreviewRequest)).then((format, notificationContexts, locale) -> this.getProject(notificationPreviewRequest)).yield((format, notificationContexts, locale, project) -> new NotificationPreviewContext(notificationPreviewRequest.getTemplate(), (Option<String>)Option.none(), (Locale)locale, (Project)project, (NotificationRenderFormat)((Object)format), (Set<NotificationContext>)notificationContexts, user, (Option<Pair<NotificationRenderFormat, String>>)Option.none(), RenderMode.CONTENT, StylingPreviewMessageField.BODY, (Option<Map<NotificationVariable, CustomPreviewData>>)Option.none()));
    }

    private io.atlassian.fugue.Either<AnError, Project> getProject(NotificationPreviewRequest notificationPreviewRequest) {
        Project project = this.projectManager.getProjectObjByKey(notificationPreviewRequest.getProjectKey());
        if (Objects.isNull(project)) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.error.project.by.key.not.found", new Object[]{notificationPreviewRequest.getProjectKey()}).build());
        }
        return io.atlassian.fugue.Either.right((Object)project);
    }

    private io.atlassian.fugue.Either<AnError, Locale> getLocale(NotificationPreviewRequest notificationPreviewRequest) {
        Locale locale = Locale.forLanguageTag(notificationPreviewRequest.getLanguageTag());
        if (Objects.equals(locale.toLanguageTag(), UNDETERMINED_LANGUAGE_TAG)) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.notifications.preview.validation.locale.invalid", new Object[]{notificationPreviewRequest.getLanguageTag()}).build());
        }
        return io.atlassian.fugue.Either.right((Object)locale);
    }

    private io.atlassian.fugue.Either<AnError, NotificationRenderFormat> getRenderFormat(NotificationPreviewRequest notificationPreviewRequest) {
        try {
            return io.atlassian.fugue.Either.right((Object)((Object)NotificationRenderFormat.valueOf(notificationPreviewRequest.getFormat().toUpperCase())));
        }
        catch (IllegalArgumentException e) {
            return io.atlassian.fugue.Either.left((Object)this.errorResultHelper.badRequest400("sd.notifications.preview.validation.render.format.invalid", new Object[]{notificationPreviewRequest.getFormat()}).build());
        }
    }

    private io.atlassian.fugue.Either<AnError, Set<NotificationContext>> getNotificationContexts(NotificationPreviewRequest notificationPreviewRequest) {
        return io.atlassian.fugue.Either.right(NotificationContext.forContextNames(notificationPreviewRequest.getContexts()));
    }
}

