/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rendering.helper;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.customfields.origin.VpOriginCustomFieldService;
import com.atlassian.servicedesk.internal.api.feedback.RequestFeedbackTokenManager;
import com.atlassian.servicedesk.internal.api.feedback.ValidatedFeedbackToken;
import com.atlassian.servicedesk.internal.api.listener.FieldChangeType;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.helper.NotificationCSATRendererHelper;
import io.atlassian.fugue.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationCSATRendererHelperImpl
implements NotificationCSATRendererHelper {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationCSATRendererHelperImpl.class);
    private VpOriginCustomFieldService vpOriginCustomFieldService;
    private RequestFeedbackTokenManager tokenManager;

    @Autowired
    public NotificationCSATRendererHelperImpl(VpOriginCustomFieldService vpOriginCustomFieldService, RequestFeedbackTokenManager tokenManager) {
        this.vpOriginCustomFieldService = vpOriginCustomFieldService;
        this.tokenManager = tokenManager;
    }

    @Override
    public Option<String> generateValidFeedbackToken(NotificationMessageMetaData metaData) {
        return Steps.begin(this.isResolutionChangeTypeSet(metaData.getResolutionChange())).then(resolutionSet -> metaData.getIssue()).then((resolutionSet, issue) -> this.checkRecipientIsReporter(metaData.getRecipient(), (Issue)issue)).then((resolutionSet, issue, validRecipient) -> this.checkIfIssueHasRequestType((Issue)issue)).then((resolutionSet, issue, validRecipient, requestType) -> this.generateToken((ApplicationUser)validRecipient, (Issue)issue)).yield((resolutionSet, issue, validRecipient, requestType, token) -> token);
    }

    private Option<FieldChangeType> isResolutionChangeTypeSet(Option<FieldChangeType> resolutionChangeType) {
        return resolutionChangeType.filter(changeType -> changeType.equals((Object)FieldChangeType.SET));
    }

    private Option<ApplicationUser> checkRecipientIsReporter(ApplicationUser recipient, Issue issue) {
        return Option.option((Object)issue.getReporterUser()).filter(reporter -> reporter.equals((Object)recipient));
    }

    private Option<Object> checkIfIssueHasRequestType(Issue issue) {
        return Option.option((Object)issue.getCustomFieldValue(this.vpOriginCustomFieldService.getVpOriginCustomField()));
    }

    private Option<String> generateToken(ApplicationUser reporter, Issue issue) {
        return (Option)this.tokenManager.generateFeedbackToken(issue).fold(e -> {
            LOG.error("Cannot generate feedback token", e);
            return Option.none();
        }, generatedToken -> this.storeToken(reporter, (ValidatedFeedbackToken)generatedToken));
    }

    private Option<String> storeToken(ApplicationUser reporter, ValidatedFeedbackToken token) {
        return (Option)this.tokenManager.storeFeedbackToken(reporter, token).fold(e -> {
            LOG.error("Cannot store feedback token", e);
            return Option.none();
        }, storedToken -> Option.some((Object)storedToken.getToken()));
    }
}

