/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rendering;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.internal.api.notifications.ServiceDeskNotificationSender;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBuilderFactory;
import com.atlassian.servicedesk.internal.api.notifications.render.RenderedHtmlContent;
import com.atlassian.servicedesk.internal.api.notifications.render.StylingBodyFinaliser;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.RenderedHtmlContentImpl;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StylingTestEmailUtils {
    private final StylingBodyFinaliser stylingBodyFinaliser;
    private final ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory;
    private final ServiceDeskNotificationSender serviceDeskNotificationSender;
    private final PortalManager portalManager;

    @Autowired
    StylingTestEmailUtils(ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory, ServiceDeskNotificationSender serviceDeskNotificationSender, PortalManager portalManager, StylingBodyFinaliser stylingBodyFinaliser) {
        this.stylingBodyFinaliser = stylingBodyFinaliser;
        this.serviceDeskEmailBuilderFactory = serviceDeskEmailBuilderFactory;
        this.serviceDeskNotificationSender = serviceDeskNotificationSender;
        this.portalManager = portalManager;
    }

    public Either<AnError, ServiceDeskEmailBody> renderHtmlBody(ApplicationUser previewingUser, String htmlContent, String plainTextContent) {
        return this.stylingBodyFinaliser.buildHtmlBody(previewingUser, (RenderedHtmlContent)new RenderedHtmlContentImpl(plainTextContent, htmlContent), Option.none());
    }

    public Either<AnError, ServiceDeskEmailBody> renderPlainTextBody(String renderedContent) {
        return this.stylingBodyFinaliser.buildTextBody(renderedContent);
    }

    public Either<AnError, String> sendTestEmail(Project project, CheckedUser recipient, ServiceDeskEmailBody body, String subject) {
        return this.retrieveFromName(project).map(portalName -> {
            String toAddress = recipient.forJIRA().getEmailAddress();
            ServiceDeskEmail email = this.serviceDeskEmailBuilderFactory.newBuilder().fromAddress(project.getEmail()).toAddress(toAddress).subject(subject).serviceDeskEmailBody(body).fromName(portalName).projectContext(Option.some((Object)project)).includeMailServerSubjectPrefix(false).build();
            this.serviceDeskNotificationSender.send(email);
            return toAddress;
        });
    }

    private Either<AnError, String> retrieveFromName(Project project) {
        return this.portalManager.getPortalByProject(project).map(Portal::getName);
    }
}

