/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rendering;

import com.atlassian.botocss.Botocss;
import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.render.RenderedHtmlContent;
import com.atlassian.servicedesk.internal.api.notifications.render.StylingBodyFinaliser;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsManager;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationInternalStylesCssLoader;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.RenderedHtmlContentImpl;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.StylingRenderParams;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.StylingRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.fixedcontent.StylingFixedContentRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class StylingEmailBodyRendererHelper {
    private final OutgoingEmailSettingsManager outgoingEmailSettingsManager;
    private final StylingBodyFinaliser stylingBodyFinaliser;
    private final StylingRenderer stylingRenderer;
    private final StylingFixedContentRenderer stylingFixedContentRenderer;
    private final LocaleManager localeManager;
    private final ErrorResultHelper errorResultHelper;
    private final NotificationInternalStylesCssLoader notificationInternalStylesCssLoader;

    @Autowired
    StylingEmailBodyRendererHelper(OutgoingEmailSettingsManager outgoingEmailSettingsManager, StylingBodyFinaliser stylingBodyFinaliser, StylingRenderer stylingRenderer, StylingFixedContentRenderer stylingFixedContentRenderer, LocaleManager localeManager, ErrorResultHelper errorResultHelper, NotificationInternalStylesCssLoader notificationInternalStylesCssLoader) {
        this.outgoingEmailSettingsManager = outgoingEmailSettingsManager;
        this.stylingBodyFinaliser = stylingBodyFinaliser;
        this.stylingRenderer = stylingRenderer;
        this.stylingFixedContentRenderer = stylingFixedContentRenderer;
        this.localeManager = localeManager;
        this.errorResultHelper = errorResultHelper;
        this.notificationInternalStylesCssLoader = notificationInternalStylesCssLoader;
    }

    Either<AnError, ServiceDeskEmailBody> renderHtmlBody(NotificationMessageMetaData metaData, RenderedHtmlContent rawContent, OutgoingEmailSettingsModel settingsModel) {
        ApplicationUser recipient = metaData.getRecipient();
        Option<LingoTranslation> htmlTemplate = this.outgoingEmailSettingsManager.resolveHtmlTemplateTranslation(recipient, settingsModel, metaData.getProject());
        if (htmlTemplate.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.outgoing.email.template.html.missing", new Object[]{recipient.getKey(), metaData.getProject().getKey()}).build());
        }
        Option<LingoTranslation> plainTextTemplate = this.outgoingEmailSettingsManager.resolvePlainTextTemplateTranslation(recipient, settingsModel, metaData.getProject());
        if (plainTextTemplate.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.outgoing.email.template.text.missing", new Object[]{recipient.getKey(), metaData.getProject().getKey()}).build());
        }
        Option<LingoTranslation> css = this.outgoingEmailSettingsManager.resolveCss(recipient, settingsModel, metaData.getProject());
        if (css.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.outgoing.email.template.css.missing", new Object[]{recipient.getKey(), metaData.getProject().getKey()}).build());
        }
        return Steps.begin(this.renderHtmlTemplate(((LingoTranslation)htmlTemplate.get()).getContent(), metaData, rawContent, ((LingoTranslation)css.get()).getContent())).then(htmlResult -> this.renderPlainTextTemplate(((LingoTranslation)plainTextTemplate.get()).getContent(), metaData, rawContent.getTextContent())).then((htmlResult, plainTextResult) -> Either.right((Object)new RenderedHtmlContentImpl((String)plainTextResult, (String)htmlResult, rawContent.shouldAttachFeedbackStar()))).then((htmlResult, plainTextResult, updatedHtmlContent) -> this.stylingBodyFinaliser.buildHtmlBody(metaData.getRecipient(), (RenderedHtmlContent)updatedHtmlContent, metaData.getIssue())).yield((htmlResult, plainTextResult, updatedHtmlContent, body) -> body);
    }

    Either<AnError, ServiceDeskEmailBody> renderPlainTextBody(NotificationMessageMetaData metaData, String rawTextContent, OutgoingEmailSettingsModel settingsModel) {
        ApplicationUser recipient = metaData.getRecipient();
        Option<LingoTranslation> plainTextTemplate = this.outgoingEmailSettingsManager.resolvePlainTextTemplateTranslation(recipient, settingsModel, metaData.getProject());
        if (plainTextTemplate.isEmpty()) {
            return Either.left((Object)this.errorResultHelper.internalServiceError500("sd.admin.outgoing.email.template.text.missing", new Object[]{recipient.getKey(), metaData.getProject().getKey()}).build());
        }
        return this.renderPlainTextTemplate(((LingoTranslation)plainTextTemplate.get()).getContent(), metaData, rawTextContent).flatMap(arg_0 -> ((StylingBodyFinaliser)this.stylingBodyFinaliser).buildTextBody(arg_0));
    }

    private Either<AnError, String> renderHtmlTemplate(String template, NotificationMessageMetaData metaData, RenderedHtmlContent rawContent, String cssString) {
        StylingRenderParams params = new StylingRenderParams(metaData.getRecipient(), (Either<String, RenderedHtmlContent>)Either.right((Object)rawContent), metaData.getProject(), metaData.getIssue());
        boolean shouldAddRepliesAbove = this.stylingFixedContentRenderer.shouldAddReplyAboveMarkerForProject(metaData.getProject());
        Locale userLocale = this.localeManager.getLocaleFor(metaData.getRecipient());
        return this.stylingRenderer.renderHtml(params, template).map(htmlBody -> this.stylingFixedContentRenderer.addContentToHtmlTemplate(userLocale, (String)htmlBody, shouldAddRepliesAbove)).map(extendedHtmlBody -> this.renderWithCss((String)extendedHtmlBody, cssString));
    }

    private String renderWithCss(String htmlBody, String cssString) {
        String styledCsat = this.notificationInternalStylesCssLoader.applyDefaultStyles(htmlBody);
        String styledHtmlBody = Botocss.inject((String)styledCsat, (String[])new String[]{cssString});
        return this.notificationInternalStylesCssLoader.applyFixedStyles(styledHtmlBody);
    }

    private Either<AnError, String> renderPlainTextTemplate(String template, NotificationMessageMetaData metaData, String rawTextContent) {
        StylingRenderParams params = new StylingRenderParams(metaData.getRecipient(), (Either<String, RenderedHtmlContent>)Either.left((Object)rawTextContent), metaData.getProject(), metaData.getIssue());
        boolean shouldAddRepliesAbove = this.stylingFixedContentRenderer.shouldAddReplyAboveMarkerForProject(metaData.getProject());
        Locale userLocale = this.localeManager.getLocaleFor(metaData.getRecipient());
        return this.stylingRenderer.renderPlainText(params, template).map(textBody -> this.stylingFixedContentRenderer.addContentToPlainTextTemplate(userLocale, (String)textBody, shouldAddRepliesAbove));
    }
}

