/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rendering;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.servicedesk.api.portal.Portal;
import com.atlassian.servicedesk.internal.api.analytics.ServiceDeskAnalyticsSourceService;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationIssueFooterRenderer;
import com.atlassian.servicedesk.internal.api.notifications.render.RenderedHtmlContent;
import com.atlassian.servicedesk.internal.api.portal.PortalManager;
import com.atlassian.servicedesk.internal.api.project.PortalUrls;
import com.atlassian.servicedesk.internal.api.project.PortalUrlsProvider;
import com.atlassian.servicedesk.internal.api.project.ProjectUrlsProvider;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationFooterRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.RenderedHtmlContentImpl;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.styling.replacement.renderers.issue.RequestSharedWithRenderer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ParametersAreNonnullByDefault
class NotificationFooterRendererImpl
implements NotificationFooterRenderer {
    private final NotificationIssueFooterRenderer notificationIssueFooterRenderer;
    private final PortalUrlsProvider portalUrlsProvider;
    private final PortalManager portalManager;
    private final ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService;
    private final RequestSharedWithRenderer requestSharedWithRenderer;

    @Autowired
    public NotificationFooterRendererImpl(NotificationIssueFooterRenderer notificationIssueFooterRenderer, PortalManager portalManager, PortalUrlsProvider portalUrlsProvider, ServiceDeskAnalyticsSourceService serviceDeskAnalyticsSourceService, RequestSharedWithRenderer requestSharedWithRenderer) {
        this.notificationIssueFooterRenderer = notificationIssueFooterRenderer;
        this.portalUrlsProvider = portalUrlsProvider;
        this.portalManager = portalManager;
        this.serviceDeskAnalyticsSourceService = serviceDeskAnalyticsSourceService;
        this.requestSharedWithRenderer = requestSharedWithRenderer;
    }

    @Override
    public String updatePlainTextWithFooterIfApplicable(NotificationMessageMetaData metaData, String currentContent) {
        return (String)metaData.getIssue().fold(() -> currentContent, issue -> this.appendFooterIfApplicable(currentContent, this.getTextNotificationFooter(metaData.getRecipient(), (Issue)issue, metaData.getProject())));
    }

    private String appendFooterIfApplicable(String originalContent, String footer) {
        if (StringUtils.isNotEmpty((String)footer)) {
            return originalContent + "\n\n\n" + footer;
        }
        return originalContent;
    }

    @Override
    public RenderedHtmlContent updateHtmlWithFooterIfApplicable(NotificationMessageMetaData metaData, RenderedHtmlContent currentHtmlContent) {
        return (RenderedHtmlContent)metaData.getIssue().fold(() -> currentHtmlContent, issue -> this.getUpdatedRenderedHtmlContentIfApplicable(metaData.getRecipient(), (Issue)issue, metaData.getProject(), currentHtmlContent));
    }

    private RenderedHtmlContent getUpdatedRenderedHtmlContentIfApplicable(ApplicationUser recipient, Issue issue, Project project, RenderedHtmlContent currentHtmlContent) {
        String textFooter = this.getTextNotificationFooter(recipient, issue, project);
        String htmlFooter = this.getHtmlNotificationFooter(recipient, issue, project);
        if (StringUtils.isNotEmpty((String)textFooter) && StringUtils.isNotEmpty((String)htmlFooter)) {
            return new RenderedHtmlContentImpl(this.appendFooterIfApplicable(currentHtmlContent.getTextContent(), textFooter), currentHtmlContent.getHtmlContent() + htmlFooter, currentHtmlContent.shouldAttachFeedbackStar());
        }
        return currentHtmlContent;
    }

    private String getTextNotificationFooter(ApplicationUser recipient, Issue issue, Project project) {
        if (StringUtils.isNotEmpty((String)issue.getKey())) {
            String requestLink = this.getPortalAndPortalLinkForIssue(issue.getKey(), project);
            String participants = this.requestSharedWithRenderer.renderRequestSharedWith(recipient, issue);
            return this.notificationIssueFooterRenderer.renderPlainTextIssueFooter(recipient, participants, issue, requestLink, project);
        }
        return "";
    }

    private String getHtmlNotificationFooter(ApplicationUser recipient, Issue issue, Project project) {
        if (StringUtils.isNotEmpty((String)issue.getKey())) {
            String requestLink = this.getPortalAndPortalLinkForIssue(issue.getKey(), project);
            String peopleInvolved = this.requestSharedWithRenderer.renderRequestSharedWith(recipient, issue);
            return this.notificationIssueFooterRenderer.renderHtmlIssueFooter(recipient, peopleInvolved, issue, requestLink, project);
        }
        return "";
    }

    private String getPortalAndPortalLinkForIssue(String issueKey, Project project) {
        return (String)this.portalManager.getPortalByProject(project).fold(e -> "", portal -> this.getPortalLinkForIssue(issueKey, (Portal)portal));
    }

    private String getPortalLinkForIssue(@Nonnull String issueKey, Portal portal) {
        PortalUrls portalUrls = this.portalUrlsProvider.getUrls(portal.getId(), ProjectUrlsProvider.UrlMode.ABSOLUTE);
        try {
            String url = portalUrls.request(issueKey).toString();
            return this.serviceDeskAnalyticsSourceService.enrichURLWithSDASource(url, "notification-email");
        }
        catch (IllegalStateException e) {
            return "";
        }
    }
}

