/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.rendering;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.notifications.internal.batching.BatchContentRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.css.NotificationsEmailCssLoader;
import com.atlassian.servicedesk.plugins.notifications.internal.css.NotificationsPreviewCssLoader;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationPreviewContext;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationContentRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRendererUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.ContentPreviewRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.content.ContentRenderer;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationContentRendererImpl
implements NotificationContentRenderer {
    private final ContentRenderer contentVariableRenderer;
    private final ContentPreviewRenderer previewVariableRenderer;
    private final NotificationRendererUtils notificationRenderer;
    private final NotificationsEmailCssLoader notificationsEmailCssLoader;
    private final NotificationsPreviewCssLoader notificationsPreviewCssLoader;
    private final BatchContentRenderer batchContentRenderer;
    private final FeatureManager featureManager;

    @Autowired
    public NotificationContentRendererImpl(ContentRenderer contentVariableRenderer, ContentPreviewRenderer previewVariableRenderer, NotificationRendererUtils notificationRenderer, NotificationsEmailCssLoader notificationsEmailCssLoader, NotificationsPreviewCssLoader notificationsPreviewCssLoader, BatchContentRenderer batchContentRenderer, FeatureManager featureManager) {
        this.contentVariableRenderer = contentVariableRenderer;
        this.previewVariableRenderer = previewVariableRenderer;
        this.notificationRenderer = notificationRenderer;
        this.notificationsEmailCssLoader = notificationsEmailCssLoader;
        this.notificationsPreviewCssLoader = notificationsPreviewCssLoader;
        this.batchContentRenderer = batchContentRenderer;
        this.featureManager = featureManager;
    }

    @Override
    public Either<AnError, String> renderContent(RecipientNotificationMessage message, NotificationRenderFormat notificationRenderFormat) {
        return Steps.begin(this.contentVariableRenderer.renderContentBeforeWikiRendering(message, notificationRenderFormat)).then(preWikiContent -> Either.right((Object)this.notificationRenderer.renderWikiContent((String)preWikiContent, message.getIssue(), notificationRenderFormat))).then((preWikiContent, postWikiContent) -> this.contentVariableRenderer.renderContentAfterWikiRendering(message, (String)postWikiContent, notificationRenderFormat)).yield((preWikiContent, postWikiContent, finalContent) -> this.applyCssIfHtml((String)finalContent, notificationRenderFormat));
    }

    @Override
    public Either<AnError, String> renderPreviewContent(NotificationPreviewContext previewContext) {
        return Steps.begin(this.previewVariableRenderer.renderPreviewBeforeWikiRendering(previewContext)).then(preWikiContent -> Either.right((Object)this.notificationRenderer.renderWikiContent((String)preWikiContent, (Option<Issue>)Option.none(), previewContext.getRenderFormat()))).then((preWikiContent, postWikiContent) -> this.previewVariableRenderer.renderPreviewAfterWikiRendering(previewContext, (String)postWikiContent)).then((preWikiContent, postWikiContent, renderedContent) -> Either.right((Object)this.applyBatchActivityItemWrapper((String)renderedContent, previewContext.getRenderFormat()))).yield((preWikiContent, postWikiContent, renderedContent, finalContent) -> this.applyCssToPreviewIfHtml((String)finalContent, previewContext.getRenderFormat()));
    }

    private String applyCssToPreviewIfHtml(String content, NotificationRenderFormat notificationRenderFormat) {
        if (notificationRenderFormat == NotificationRenderFormat.HTML) {
            return this.notificationsPreviewCssLoader.applyStyles(content);
        }
        return content;
    }

    private String applyBatchActivityItemWrapper(String content, NotificationRenderFormat notificationRenderFormat) {
        if (notificationRenderFormat == NotificationRenderFormat.HTML) {
            return this.batchContentRenderer.renderContentAsHtml(Collections.singletonList(content));
        }
        return content;
    }

    private String applyCssIfHtml(String content, NotificationRenderFormat notificationRenderFormat) {
        if (notificationRenderFormat == NotificationRenderFormat.HTML && !this.featureManager.isEnabled("sd.custom.email.notifications.styling")) {
            return this.notificationsEmailCssLoader.applyStyles(content);
        }
        return content;
    }
}

