/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.recipients;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationRecipientType;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.RecipientConfigurationManager;
import com.atlassian.servicedesk.plugins.notifications.internal.recipients.RecipientConfigurationService;
import com.atlassian.servicedesk.plugins.notifications.internal.security.NotificationPermissionService;
import io.atlassian.fugue.Either;
import java.util.Set;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RecipientConfigurationServiceImpl
implements RecipientConfigurationService {
    private final NotificationPermissionService notificationPermissionService;
    private final RecipientConfigurationManager recipientConfigurationManager;

    @Autowired
    public RecipientConfigurationServiceImpl(NotificationPermissionService notificationPermissionService, RecipientConfigurationManager recipientConfigurationManager) {
        this.notificationPermissionService = notificationPermissionService;
        this.recipientConfigurationManager = recipientConfigurationManager;
    }

    @Override
    public Either<AnError, Set<NotificationRecipientType>> retrieveAvailableRecipientsTypes(@Nonnull ApplicationUser user, long projectId) {
        return this.notificationPermissionService.checkProjectAdminPermission(user, projectId).map(permission -> NotificationRecipientType.retrieveAvailableRecipientTypes());
    }
}

