/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.preview;

import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.user.SDUser;
import com.atlassian.servicedesk.internal.api.user.permission.ServiceDeskLicenseAndPermissionService;
import com.atlassian.servicedesk.plugins.notifications.internal.preview.StylingPreviewData;
import com.atlassian.servicedesk.plugins.notifications.internal.preview.StylingPreviewManager;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class StylingPreviewService {
    private final StylingPreviewManager stylingPreviewManager;
    private final ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService;
    private final ErrorResultHelper errorResultHelper;

    @Autowired
    public StylingPreviewService(StylingPreviewManager stylingPreviewManager, ServiceDeskLicenseAndPermissionService serviceDeskLicenseAndPermissionService, ErrorResultHelper errorResultHelper) {
        this.stylingPreviewManager = stylingPreviewManager;
        this.serviceDeskLicenseAndPermissionService = serviceDeskLicenseAndPermissionService;
        this.errorResultHelper = errorResultHelper;
    }

    public Either<AnError, String> renderPreview(StylingPreviewData data) {
        return this.checkAdministerPermission(data).flatMap(permission -> this.stylingPreviewManager.renderPreview(data));
    }

    public Either<AnError, String> sendTestEmail(StylingPreviewData data) {
        return this.checkAdministerPermission(data).flatMap(permission -> this.stylingPreviewManager.sendTestEmail(data));
    }

    private Either<AnError, Unit> checkAdministerPermission(StylingPreviewData data) {
        if (!this.serviceDeskLicenseAndPermissionService.canAdministerServiceDesk((SDUser)data.getUser(), data.getProject())) {
            return Either.left((Object)this.errorResultHelper.forbidden403("sd.admin.servicedesk.common.error.permissions", new Object[0]).build());
        }
        return Either.right((Object)Unit.Unit());
    }
}

