/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation;

import com.atlassian.jira.util.I18nHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.StylingVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.ValidatorUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.rest.response.VariableGroup;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.ResolvedVariables;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.VariableResolutionManager;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.configuration.AvailableVariableManager;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class TemplateValidator {
    private final I18nHelper i18nHelper;
    private final AvailableVariableManager availableVariableManager;
    private final VariableResolutionManager variableResolutionManager;

    @Autowired
    public TemplateValidator(I18nHelper i18nHelper, AvailableVariableManager availableVariableManager, VariableResolutionManager variableResolutionManager) {
        this.i18nHelper = i18nHelper;
        this.availableVariableManager = availableVariableManager;
        this.variableResolutionManager = variableResolutionManager;
    }

    Option<List<String>> validateHtmlInput(Map<Locale, String> input) {
        if (ValidatorUtils.isAllEmpty(input)) {
            return Option.some(Collections.singletonList(this.i18nHelper.getText("sd.admin.outgoing.email.template.required")));
        }
        return this.validateVariablesInInput(input);
    }

    Option<List<String>> validatePlainTextInput(Map<Locale, String> input) {
        if (ValidatorUtils.isAllEmpty(input)) {
            return Option.some(Collections.singletonList(this.i18nHelper.getText("sd.admin.outgoing.email.template.required")));
        }
        return this.validateVariablesInInput(input);
    }

    private Option<List<String>> validateVariablesInInput(Map<Locale, String> input) {
        List validationError = input.entrySet().stream().flatMap(entry -> this.validateVariablesInTemplate((Locale)entry.getKey(), (String)entry.getValue()).stream()).collect(Collectors.toList());
        if (validationError.isEmpty()) {
            return Option.none();
        }
        return Option.some(validationError);
    }

    private List<String> validateVariablesInTemplate(Locale locale, String template) {
        ResolvedVariables resolvedVariables = this.variableResolutionManager.resolveVariables(template, this.getAvailableStylingVariables());
        if (StringUtils.isBlank((String)template)) {
            return Lists.newArrayList((Object[])new String[]{this.formatErrorMessage(locale, "sd.admin.outgoing.email.template.blank", (Option<String>)Option.none())});
        }
        Set<String> invalidVariable = resolvedVariables.getInvalidVariables();
        Option invalidVariablesArg = Option.option((Object)Joiner.on((String)", ").join(invalidVariable));
        if (invalidVariable.size() == 1) {
            return Lists.newArrayList((Object[])new String[]{this.formatErrorMessage(locale, "sd.admin.outgoing.email.template.invalid.variable", (Option<String>)invalidVariablesArg)});
        }
        if (invalidVariable.size() > 1) {
            return Lists.newArrayList((Object[])new String[]{this.formatErrorMessage(locale, "sd.admin.outgoing.email.template.invalid.variables", (Option<String>)invalidVariablesArg)});
        }
        if (!resolvedVariables.getValidVariables().contains(StylingVariable.MESSAGE_CONTENT)) {
            return Lists.newArrayList((Object[])new String[]{this.formatErrorMessage(locale, "sd.admin.outgoing.email.template.missing.content.message", (Option<String>)Option.none())});
        }
        return Collections.EMPTY_LIST;
    }

    private Set<NotificationVariable> getAvailableStylingVariables() {
        return ((List)this.availableVariableManager.retrieveAvailableStylingVariableGroups().getOrElse(Collections.emptyList())).stream().flatMap(group -> group.getVariables().stream().map(VariableGroup.Variable::getKey)).flatMap(variableKey -> (Stream)VariableResolutionManager.toNotificationVariable(variableKey).fold(Stream::empty, Stream::of)).collect(Collectors.toSet());
    }

    private String formatErrorMessage(Locale locale, String i18nKey, Option<String> arg) {
        String localeDisplayName = locale.getDisplayName(this.i18nHelper.getLocale());
        return String.format("%s: %s", localeDisplayName, this.i18nHelper.getText(i18nKey, (String)arg.getOrElse((Object)"")));
    }
}

