/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.memo;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsManager;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.memo.OutgoingEmailSettingsMemo;
import io.atlassian.fugue.Option;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutgoingEmailSettingsMemoFactory {
    private final ProjectManager projectManager;
    private final ServiceDeskManager serviceDeskManager;
    private final OutgoingEmailSettingsManager outgoingEmailSettingsManager;

    @Autowired
    public OutgoingEmailSettingsMemoFactory(ProjectManager projectManager, ServiceDeskManager serviceDeskManager, OutgoingEmailSettingsManager outgoingEmailSettingsManager) {
        this.projectManager = projectManager;
        this.serviceDeskManager = serviceDeskManager;
        this.outgoingEmailSettingsManager = outgoingEmailSettingsManager;
    }

    public OutgoingEmailSettingsMemo createNewOutgoingEmailSettingsMemo() {
        return new OutgoingEmailSettingsMemoImpl();
    }

    private class OutgoingEmailSettingsMemoImpl
    implements OutgoingEmailSettingsMemo {
        @TenantAware(value=TenancyScope.TENANTED)
        private final Map<Long, OutgoingEmailSettingsModel> settingsPerServiceDeskProject = new HashMap<Long, OutgoingEmailSettingsModel>();

        private OutgoingEmailSettingsMemoImpl() {
        }

        @Override
        public Option<OutgoingEmailSettingsModel> retrieveSettingsForServiceDesk(long projectId) {
            Option existingSettingsOpt = Option.option((Object)this.settingsPerServiceDeskProject.get(projectId));
            return (Option)existingSettingsOpt.fold(() -> this.retrieveSettingsInternal(projectId), Option::some);
        }

        private Option<OutgoingEmailSettingsModel> retrieveSettingsInternal(long projectId) {
            Option settingsOption = this.retrieveProject(projectId).flatMap(project -> OutgoingEmailSettingsMemoFactory.this.serviceDeskManager.getServiceDeskForProject(project).toOption()).flatMap(serviceDesk -> OutgoingEmailSettingsMemoFactory.this.outgoingEmailSettingsManager.retrieveSettings((ServiceDesk)serviceDesk).toOption());
            settingsOption.forEach(settings -> this.settingsPerServiceDeskProject.put(projectId, (OutgoingEmailSettingsModel)settings));
            return settingsOption;
        }

        private Option<Project> retrieveProject(long projectId) {
            return Option.option((Object)OutgoingEmailSettingsMemoFactory.this.projectManager.getProjectObj(Long.valueOf(projectId)));
        }
    }
}

