/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailLingoHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsManager;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModelImpl;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsStore;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsStoreModel;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.request.OutgoingEmailSettingsInput;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.OutgoingEmailSettingsValidator;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.validation.ValidationFailure;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class OutgoingEmailSettingsManagerImpl
implements OutgoingEmailSettingsManager {
    private final OutgoingEmailSettingsStore outgoingEmailSettingsStore;
    private final ErrorResultHelper errorResultHelper;
    private final OutgoingEmailLingoHelper lingoHelper;
    private final OutgoingEmailSettingsValidator outgoingEmailSettingsValidator;

    @Autowired
    public OutgoingEmailSettingsManagerImpl(OutgoingEmailSettingsStore outgoingEmailSettingsStore, ErrorResultHelper errorResultHelper, OutgoingEmailLingoHelper lingoHelper, OutgoingEmailSettingsValidator outgoingEmailSettingsValidator) {
        this.outgoingEmailSettingsStore = outgoingEmailSettingsStore;
        this.errorResultHelper = errorResultHelper;
        this.lingoHelper = lingoHelper;
        this.outgoingEmailSettingsValidator = outgoingEmailSettingsValidator;
    }

    @Override
    public Either<AnError, OutgoingEmailSettingsModel> retrieveSettings(ServiceDesk serviceDesk) {
        Option<OutgoingEmailSettingsStoreModel> daoModelOpt = this.outgoingEmailSettingsStore.retrieveSettings(serviceDesk);
        OutgoingEmailSettingsModel settingsModel = (OutgoingEmailSettingsModel)daoModelOpt.fold(() -> this.storeToPublicModel(serviceDesk, (Option<OutgoingEmailSettingsStoreModel>)Option.none()), daoModel -> this.storeToPublicModel(serviceDesk, (Option<OutgoingEmailSettingsStoreModel>)Option.some((Object)daoModel)));
        return Either.right((Object)settingsModel);
    }

    @Override
    public Either<AnError, Either<ValidationFailure, OutgoingEmailSettingsModel>> updateSettings(ServiceDesk serviceDesk, OutgoingEmailSettingsInput input) {
        return (Either)this.outgoingEmailSettingsValidator.validateInput(input).fold(validationFailure -> Either.right((Object)Either.left((Object)validationFailure)), validatedInput -> (Either)this.updateSettingsInternal(serviceDesk, (OutgoingEmailSettingsInput)validatedInput).fold(Either::left, updatedModel -> Either.right((Object)Either.right((Object)updatedModel))));
    }

    private Either<AnError, OutgoingEmailSettingsModel> updateSettingsInternal(ServiceDesk serviceDesk, OutgoingEmailSettingsInput validatedInput) {
        return (Either)this.outgoingEmailSettingsStore.retrieveSettings(serviceDesk).fold(() -> this.insertNewSettings(serviceDesk, validatedInput), existingSettings -> this.updateExistingSettings(serviceDesk, validatedInput, (OutgoingEmailSettingsStoreModel)existingSettings));
    }

    private Either<AnError, OutgoingEmailSettingsModel> insertNewSettings(ServiceDesk serviceDesk, OutgoingEmailSettingsInput input) {
        Set<Locale> forcedToSaveLanguages = this.lingoHelper.getModifiedLanguages(input, serviceDesk);
        Either modelToStoreEither = Steps.begin(this.lingoHelper.storeEmailSubjectLingo(serviceDesk, input, (Option<OutgoingEmailSettingsStoreModel>)Option.none())).then(subjectLingo -> this.lingoHelper.storeHtmlTemplateLingo(serviceDesk, input, (Option<OutgoingEmailSettingsStoreModel>)Option.none(), forcedToSaveLanguages)).then((subjectLingo, htmlLingo) -> this.lingoHelper.storePlainTextLingo(serviceDesk, input, (Option<OutgoingEmailSettingsStoreModel>)Option.none(), forcedToSaveLanguages)).then((subjectLingo, htmlLingo, plainTextLingo) -> this.lingoHelper.storeCssTemplateLingo(serviceDesk, input, (Option<OutgoingEmailSettingsStoreModel>)Option.none(), forcedToSaveLanguages)).yield((subjectLingo, htmlLingo, plainTextLingo, cssLingo) -> new OutgoingEmailSettingsStoreModel(serviceDesk.getProjectId(), (Long)subjectLingo.getOrNull(), (Long)htmlLingo.getOrNull(), (String)cssLingo.map(String::valueOf).getOrNull(), (Long)plainTextLingo.getOrNull()));
        return modelToStoreEither.flatMap(modelToStore -> this.insertNewSettings(serviceDesk, (OutgoingEmailSettingsStoreModel)modelToStore));
    }

    private Either<AnError, OutgoingEmailSettingsModel> updateExistingSettings(ServiceDesk serviceDesk, OutgoingEmailSettingsInput input, OutgoingEmailSettingsStoreModel existingSettings) {
        Set<Locale> forcedToSaveLanguages = this.lingoHelper.getModifiedLanguages(input, serviceDesk);
        Either modelToStoreEither = Steps.begin(this.lingoHelper.storeEmailSubjectLingo(serviceDesk, input, (Option<OutgoingEmailSettingsStoreModel>)Option.some((Object)existingSettings))).then(subjectLingo -> this.lingoHelper.storeHtmlTemplateLingo(serviceDesk, input, (Option<OutgoingEmailSettingsStoreModel>)Option.some((Object)existingSettings), forcedToSaveLanguages)).then((subjectLingo, htmlTemplateLingo) -> this.lingoHelper.storePlainTextLingo(serviceDesk, input, (Option<OutgoingEmailSettingsStoreModel>)Option.some((Object)existingSettings), forcedToSaveLanguages)).then((subjectLingo, htmlTemplateLingo, plainTextLingo) -> this.lingoHelper.storeCssTemplateLingo(serviceDesk, input, (Option<OutgoingEmailSettingsStoreModel>)Option.some((Object)existingSettings), forcedToSaveLanguages)).yield((subjectLingo, htmlTemplateLingo, plainTextLingo, cssLingo) -> this.updateSettingsWithNewlyStoredLingos(existingSettings, (Option<Long>)subjectLingo, (Option<Long>)htmlTemplateLingo, (Option<Long>)plainTextLingo, (Option<Long>)cssLingo));
        return modelToStoreEither.flatMap(modelToStore -> this.updateExistingSettings(serviceDesk, (OutgoingEmailSettingsStoreModel)modelToStore));
    }

    private OutgoingEmailSettingsStoreModel updateSettingsWithNewlyStoredLingos(OutgoingEmailSettingsStoreModel existingSettings, Option<Long> updatedSubjectLingo, Option<Long> updatedHtmlTemplate, Option<Long> updatedPlainTextTemplate, Option<Long> cssLingo) {
        return new OutgoingEmailSettingsStoreModel(existingSettings.getProjectId(), (Long)updatedSubjectLingo.orElse(existingSettings.getSubjectLingoId()).getOrNull(), (Long)updatedHtmlTemplate.orElse(existingSettings.getHtmlTemplateLingoId()).getOrNull(), (String)cssLingo.map(String::valueOf).getOrNull(), (Long)updatedPlainTextTemplate.orElse(existingSettings.getPlainTextLingoId()).getOrNull());
    }

    private Either<AnError, OutgoingEmailSettingsModel> insertNewSettings(ServiceDesk serviceDesk, OutgoingEmailSettingsStoreModel modelToStore) {
        return this.outgoingEmailSettingsStore.insertSettings(modelToStore).toRight(() -> this.errorResultHelper.internalServiceError500("sd.admin.outgoing.email.project.template.store.error", new Object[0]).build()).map(storedModel -> this.storeToPublicModel(serviceDesk, (Option<OutgoingEmailSettingsStoreModel>)Option.some((Object)storedModel)));
    }

    private Either<AnError, OutgoingEmailSettingsModel> updateExistingSettings(ServiceDesk serviceDesk, OutgoingEmailSettingsStoreModel modelToStore) {
        return this.outgoingEmailSettingsStore.updateSettings(modelToStore).toRight(() -> this.errorResultHelper.internalServiceError500("sd.admin.outgoing.email.project.template.store.error", new Object[0]).build()).map(storedModel -> this.storeToPublicModel(serviceDesk, (Option<OutgoingEmailSettingsStoreModel>)Option.some((Object)storedModel)));
    }

    @Override
    public boolean deleteSettings(Project project) {
        return this.outgoingEmailSettingsStore.deleteSettings(project);
    }

    @Override
    public Option<LingoTranslation> resolveHtmlTemplateTranslation(ApplicationUser user, OutgoingEmailSettingsModel settingsModel, Project project) {
        return this.lingoHelper.resolveLingoTranslationForUser(user, settingsModel.getHtmlTemplate(), (Option<Long>)Option.some((Object)project.getId()));
    }

    @Override
    public Option<LingoTranslation> resolvePlainTextTemplateTranslation(ApplicationUser user, OutgoingEmailSettingsModel settingsModel, Project project) {
        return this.lingoHelper.resolveLingoTranslationForUser(user, settingsModel.getPlainTextTemplate(), (Option<Long>)Option.some((Object)project.getId()));
    }

    @Override
    public Option<LingoTranslation> resolveCss(ApplicationUser user, OutgoingEmailSettingsModel settingsModel, Project project) {
        return this.lingoHelper.resolveLingoTranslationForUser(user, settingsModel.getCss(), (Option<Long>)Option.some((Object)project.getId()));
    }

    private OutgoingEmailSettingsModel storeToPublicModel(ServiceDesk serviceDesk, Option<OutgoingEmailSettingsStoreModel> storeModelOpt) {
        long projectId = serviceDesk.getProjectId();
        Option emailSubjectLingoId = storeModelOpt.flatMap(OutgoingEmailSettingsStoreModel::getSubjectLingoId);
        Map<Locale, Supplier<String>> subject = this.lingoHelper.getSubject(serviceDesk, (Option<Long>)emailSubjectLingoId);
        Option htmlTemplateLingoId = storeModelOpt.flatMap(OutgoingEmailSettingsStoreModel::getHtmlTemplateLingoId);
        Map<Locale, Supplier<String>> htmlTemplate = this.lingoHelper.getHtmlTemplate(serviceDesk, (Option<Long>)htmlTemplateLingoId);
        Option plainTextTemplateLingoId = storeModelOpt.flatMap(OutgoingEmailSettingsStoreModel::getPlainTextLingoId);
        Map<Locale, Supplier<String>> plainTextTemplate = this.lingoHelper.getPlainTextTemplate(serviceDesk, (Option<Long>)plainTextTemplateLingoId);
        Option cssLingoId = storeModelOpt.flatMap(OutgoingEmailSettingsStoreModel::getCssLingoId);
        Map<Locale, Supplier<String>> css = this.lingoHelper.getCss(projectId, (Option<Long>)cssLingoId);
        return new OutgoingEmailSettingsModelImpl(serviceDesk, subject, htmlTemplate, css, plainTextTemplate);
    }
}

