/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.commons.jira.ErrorResultHelper;
import com.atlassian.servicedesk.api.ServiceDesk;
import com.atlassian.servicedesk.internal.api.lingo.languageresolution.LingoLanguageResolutionManager;
import com.atlassian.servicedesk.internal.api.lingo.manager.LingoManager;
import com.atlassian.servicedesk.internal.api.lingo.project.LingoProjectLanguageManager;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInput;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInputBuilder;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoInputBuilderFactory;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoQueryRequest;
import com.atlassian.servicedesk.internal.api.lingo.request.LingoQueryRequestFactory;
import com.atlassian.servicedesk.internal.api.lingo.response.Lingo;
import com.atlassian.servicedesk.internal.api.lingo.response.LingoTranslation;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailDefaultCssLoader;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailDefaultHtmlTemplateProvider;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailDefaultPlainTextTemplateProvider;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsStoreModel;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.request.OutgoingEmailSettingsInput;
import com.atlassian.servicedesk.plugins.notifications.internal.subject.EmailSubjectManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Option;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class OutgoingEmailLingoHelper {
    private static final String SUBJECT_CATEGORY = "sd.notifications.custom.email.subject";
    private static final String HTML_TEMPLATE_CATEGORY = "sd.notifications.custom.email.html.template";
    private static final String CSS_TEMPLATE_CATEGORY = "sd.notifications.custom.email.template.css";
    private static final String PLAIN_TEXT_TEMPLATE_CATEGORY = "sd.notifications.custom.email.plaintext.template";
    private final LingoInputBuilderFactory lingoInputBuilderFactory;
    private final LingoQueryRequestFactory lingoQueryRequestFactory;
    private final LingoManager lingoManager;
    private final ErrorResultHelper errorResultHelper;
    private final EmailSubjectManager emailSubjectManager;
    private final LingoProjectLanguageManager lingoProjectLanguageManager;
    private final OutgoingEmailDefaultHtmlTemplateProvider defaultHtmlTemplateProvider;
    private final OutgoingEmailDefaultPlainTextTemplateProvider defaultPlainTextTemplateProvider;
    private final LingoLanguageResolutionManager lingoLanguageResolutionManager;
    private final OutgoingEmailDefaultCssLoader defaultCssProvider;

    @Autowired
    public OutgoingEmailLingoHelper(LingoInputBuilderFactory lingoInputBuilderFactory, LingoQueryRequestFactory lingoQueryRequestFactory, LingoManager lingoManager, ErrorResultHelper errorResultHelper, EmailSubjectManager emailSubjectManager, LingoProjectLanguageManager lingoProjectLanguageManager, OutgoingEmailDefaultHtmlTemplateProvider defaultHtmlTemplateProvider, OutgoingEmailDefaultPlainTextTemplateProvider defaultPlainTextTemplateProvider, LingoLanguageResolutionManager lingoLanguageResolutionManager, OutgoingEmailDefaultCssLoader defaultCssProvider) {
        this.lingoInputBuilderFactory = lingoInputBuilderFactory;
        this.lingoQueryRequestFactory = lingoQueryRequestFactory;
        this.lingoManager = lingoManager;
        this.errorResultHelper = errorResultHelper;
        this.emailSubjectManager = emailSubjectManager;
        this.lingoProjectLanguageManager = lingoProjectLanguageManager;
        this.defaultHtmlTemplateProvider = defaultHtmlTemplateProvider;
        this.defaultPlainTextTemplateProvider = defaultPlainTextTemplateProvider;
        this.lingoLanguageResolutionManager = lingoLanguageResolutionManager;
        this.defaultCssProvider = defaultCssProvider;
    }

    Map<Locale, Supplier<String>> getSubject(ServiceDesk serviceDesk, Option<Long> existingLingoId) {
        Function<Locale, String> defaultSubjectProvider = this.defaultSubjectProviderFunction();
        return this.retrieveTranslations(serviceDesk.getProjectId(), existingLingoId, defaultSubjectProvider);
    }

    Map<Locale, Supplier<String>> getHtmlTemplate(ServiceDesk serviceDesk, Option<Long> existingLingoId) {
        return this.retrieveTranslations(serviceDesk.getProjectId(), existingLingoId, this.defaultHtmlProviderFunction(serviceDesk));
    }

    Map<Locale, Supplier<String>> getPlainTextTemplate(ServiceDesk serviceDesk, Option<Long> existingLingoId) {
        return this.retrieveTranslations(serviceDesk.getProjectId(), existingLingoId, this.defaultPlainTextProviderFunction(serviceDesk));
    }

    Map<Locale, Supplier<String>> getCss(long projectId, Option<Long> cssLingoId) {
        return this.retrieveTranslations(projectId, cssLingoId, this.defaultCssProvider);
    }

    Set<Locale> getModifiedLanguages(OutgoingEmailSettingsInput input, ServiceDesk serviceDesk) {
        Set<Locale> cssChangedLanguages = this.getLanguagesDifferentFromDefault((Map)input.getCss().getOrElse(Collections.emptyMap()), this.defaultCssProvider);
        Set<Locale> htmlChangedLanguages = this.getLanguagesDifferentFromDefault((Map)input.getHtmlTemplate().getOrElse(Collections.emptyMap()), this.defaultHtmlProviderFunction(serviceDesk));
        Set<Locale> plainTextChangedLanguages = this.getLanguagesDifferentFromDefault((Map)input.getPlainTextTemplate().getOrElse(Collections.emptyMap()), this.defaultPlainTextProviderFunction(serviceDesk));
        return Sets.union((Set)Sets.union(cssChangedLanguages, htmlChangedLanguages), plainTextChangedLanguages);
    }

    private Set<Locale> getLanguagesDifferentFromDefault(Map<Locale, String> toCompare, Function<Locale, String> defaultProvider) {
        return toCompare.entrySet().stream().filter(entry -> !Objects.equals(entry.getValue(), defaultProvider.apply((Locale)entry.getKey()))).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    Either<AnError, Option<Long>> storeEmailSubjectLingo(ServiceDesk serviceDesk, OutgoingEmailSettingsInput input, Option<OutgoingEmailSettingsStoreModel> existingSettings) {
        Option existingLingoIdOpt = existingSettings.flatMap(OutgoingEmailSettingsStoreModel::getSubjectLingoId);
        if (input.getEmailSubject().isDefined()) {
            Map emailSubject = (Map)input.getEmailSubject().get();
            return this.storeLingo(serviceDesk, emailSubject, (Option<Long>)existingLingoIdOpt, SUBJECT_CATEGORY, (Option<String>)Option.none(), (Option<Function<Locale, String>>)Option.some(this.defaultSubjectProviderFunction()), "subject");
        }
        return Either.right((Object)existingLingoIdOpt);
    }

    Either<AnError, Option<Long>> storeHtmlTemplateLingo(ServiceDesk serviceDesk, OutgoingEmailSettingsInput input, Option<OutgoingEmailSettingsStoreModel> existingSettings, Set<Locale> forcedToSaveLanguage) {
        Option existingLingoIdOpt = existingSettings.flatMap(OutgoingEmailSettingsStoreModel::getHtmlTemplateLingoId);
        if (input.getHtmlTemplate().isDefined()) {
            Map htmlTemplate = (Map)input.getHtmlTemplate().get();
            return this.storeLingo(serviceDesk, htmlTemplate, (Option<Long>)existingLingoIdOpt, HTML_TEMPLATE_CATEGORY, (Option<String>)Option.none(), (Option<Function<Locale, String>>)Option.some(this.forcedSaveDefaultProviderFunction(forcedToSaveLanguage, this.defaultHtmlProviderFunction(serviceDesk))), "html");
        }
        return Either.right((Object)existingLingoIdOpt);
    }

    Either<AnError, Option<Long>> storeCssTemplateLingo(ServiceDesk serviceDesk, OutgoingEmailSettingsInput input, Option<OutgoingEmailSettingsStoreModel> existingSettings, Set<Locale> forcedToSaveLanguage) {
        Option existingLingoIdOpt = existingSettings.flatMap(OutgoingEmailSettingsStoreModel::getCssLingoId);
        return (Either)input.getCss().map(css -> this.storeLingo(serviceDesk, (Map<Locale, String>)css, (Option<Long>)existingLingoIdOpt, CSS_TEMPLATE_CATEGORY, (Option<String>)Option.none(), (Option<Function<Locale, String>>)Option.some(this.forcedSaveDefaultProviderFunction(forcedToSaveLanguage, this.defaultCssProvider)), "css")).getOrElse((Object)Either.right((Object)existingLingoIdOpt));
    }

    Either<AnError, Option<Long>> storePlainTextLingo(ServiceDesk serviceDesk, OutgoingEmailSettingsInput input, Option<OutgoingEmailSettingsStoreModel> existingSettings, Set<Locale> forcedToSaveLanguage) {
        Option existingLingoIdOpt = existingSettings.flatMap(OutgoingEmailSettingsStoreModel::getPlainTextLingoId);
        if (input.getPlainTextTemplate().isDefined()) {
            Map plainTextTemplate = (Map)input.getPlainTextTemplate().get();
            return this.storeLingo(serviceDesk, plainTextTemplate, (Option<Long>)existingLingoIdOpt, PLAIN_TEXT_TEMPLATE_CATEGORY, (Option<String>)Option.none(), (Option<Function<Locale, String>>)Option.some(this.forcedSaveDefaultProviderFunction(forcedToSaveLanguage, this.defaultPlainTextProviderFunction(serviceDesk))), "plaintext");
        }
        return Either.right((Object)existingLingoIdOpt);
    }

    @VisibleForTesting
    Function<Locale, String> forcedSaveDefaultProviderFunction(Set<Locale> forcedSaveLanguage, Function<Locale, String> originalDefaultProvider) {
        return locale -> {
            if (forcedSaveLanguage.contains(locale)) {
                return "";
            }
            return (String)originalDefaultProvider.apply((Locale)locale);
        };
    }

    private Function<Locale, String> defaultSubjectProviderFunction() {
        return locale -> this.emailSubjectManager.getDefaultRequestEmailSubject();
    }

    private Function<Locale, String> defaultHtmlProviderFunction(ServiceDesk serviceDesk) {
        return locale -> this.defaultHtmlTemplateProvider.getDefaultTemplate((Locale)locale, serviceDesk);
    }

    private Function<Locale, String> defaultPlainTextProviderFunction(ServiceDesk serviceDesk) {
        return locale -> this.defaultPlainTextTemplateProvider.getDefaultTemplate((Locale)locale, serviceDesk);
    }

    Option<LingoTranslation> resolveLingoTranslationForUser(ApplicationUser user, Map<Locale, Supplier<String>> translations, Option<Long> projectId) {
        return this.lingoLanguageResolutionManager.resolveTranslationForUserFromSupplierMap(translations, user, projectId);
    }

    Option<Lingo> getLingoById(long lingoId) {
        LingoQueryRequest lingoQueryRequest = this.lingoQueryRequestFactory.createLingoQueryRequest(Long.valueOf(lingoId));
        return this.lingoManager.retrieveLingo(lingoQueryRequest);
    }

    private Map<Locale, Supplier<String>> retrieveTranslations(long projectId, Option<Long> existingLingoId, Function<Locale, String> defaultValueProvider) {
        return (Map)existingLingoId.flatMap(lingoId -> {
            LingoQueryRequest lingoQueryRequest = this.lingoQueryRequestFactory.createLingoQueryRequest(lingoId);
            return this.lingoManager.retrieveLingo(lingoQueryRequest, defaultValueProvider);
        }).map(this::lingoTranslationsToMap).getOr(() -> this.createDefaultTranslationsMap(projectId, defaultValueProvider));
    }

    private Either<AnError, Option<Long>> storeLingo(ServiceDesk serviceDesk, Map<Locale, String> translations, Option<Long> existingLingoIdOpt, String category, Option<String> systemI18nOpt, Option<Function<Locale, String>> defaultValueProviderOpt, String fieldNameForError) {
        LingoInputBuilder lingoInputBuilder = (LingoInputBuilder)existingLingoIdOpt.fold(() -> ((LingoInputBuilderFactory)this.lingoInputBuilderFactory).newBuilder(), arg_0 -> ((LingoInputBuilderFactory)this.lingoInputBuilderFactory).newBuilderWithTechnicalId(arg_0));
        lingoInputBuilder.projectId(Long.valueOf(serviceDesk.getProjectId())).category(category);
        systemI18nOpt.forEach(arg_0 -> ((LingoInputBuilder)lingoInputBuilder).systemI18n(arg_0));
        translations.forEach((arg_0, arg_1) -> ((LingoInputBuilder)lingoInputBuilder).addTranslation(arg_0, arg_1));
        return lingoInputBuilder.build().flatMap(lingoInput -> this.storeLingoInput((LingoInput)lingoInput, defaultValueProviderOpt, fieldNameForError)).map(Option::some);
    }

    private Either<AnError, Long> storeLingoInput(LingoInput lingoInput, Option<Function<Locale, String>> defaultValueProviderOpt, String fieldNameForError) {
        Option storedLingoIdOpt = (Option)defaultValueProviderOpt.fold(() -> this.lingoManager.storeLingo(lingoInput), defaultValueProvider -> this.lingoManager.storeLingo(lingoInput, defaultValueProvider));
        return storedLingoIdOpt.toRight(() -> this.errorResultHelper.internalServiceError500("sd.admin.outgoing.email.project.template.lingo.store.error", new Object[]{fieldNameForError}).build());
    }

    private Map<Locale, Supplier<String>> lingoTranslationsToMap(Lingo lingo) {
        return lingo.getTranslations().stream().collect(Collectors.toMap(LingoTranslation::getLocale, translation -> () -> translation.getContent()));
    }

    private Map<Locale, Supplier<String>> createDefaultTranslationsMap(long projectId, Function<Locale, String> defaultValueProvider) {
        return this.lingoProjectLanguageManager.retrieveProjectLocales(Long.valueOf(projectId), true).stream().collect(Collectors.toMap(locale -> locale, locale -> () -> (String)defaultValueProvider.apply((Locale)locale)));
    }
}

