/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.message;

import com.atlassian.jira.project.Project;
import com.atlassian.servicedesk.api.user.CheckedUser;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationContext;
import com.atlassian.servicedesk.plugins.notifications.internal.configuration.NotificationVariable;
import com.atlassian.servicedesk.plugins.notifications.internal.message.CustomPreviewData;
import com.atlassian.servicedesk.plugins.notifications.internal.message.StylingPreviewMessageField;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationRenderFormat;
import com.atlassian.servicedesk.plugins.notifications.internal.variables.RenderMode;
import com.google.common.base.Objects;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Pair;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

public class NotificationPreviewContext {
    private final String rawContent;
    private final Option<String> css;
    private final Locale locale;
    private final Project project;
    private final NotificationRenderFormat renderFormat;
    private final Set<NotificationContext> notificationContexts;
    private final CheckedUser previewingUser;
    private final Option<Pair<NotificationRenderFormat, String>> additionalContentFormat;
    private final StylingPreviewMessageField stylingPreviewMessageField;
    private final RenderMode renderMode;
    private final Map<NotificationVariable, CustomPreviewData> variableCustomPreviewDataMap;

    public NotificationPreviewContext(String rawContent, Option<String> css, Locale locale, Project project, NotificationRenderFormat renderFormat, Set<NotificationContext> notificationContexts, CheckedUser previewingUser, Option<Pair<NotificationRenderFormat, String>> additionalContentFormat, RenderMode renderMode, StylingPreviewMessageField stylingPreviewMessageField, Option<Map<NotificationVariable, CustomPreviewData>> customPreviewData) {
        this.rawContent = rawContent;
        this.css = css;
        this.locale = locale;
        this.project = project;
        this.renderFormat = renderFormat;
        this.notificationContexts = notificationContexts;
        this.previewingUser = previewingUser;
        this.additionalContentFormat = additionalContentFormat;
        this.stylingPreviewMessageField = stylingPreviewMessageField;
        this.renderMode = renderMode;
        this.variableCustomPreviewDataMap = (Map)customPreviewData.getOrElse(Collections.emptyMap());
    }

    private NotificationPreviewContext(Builder builder) {
        this.rawContent = builder.rawContent;
        this.css = builder.css;
        this.locale = builder.locale;
        this.project = builder.project;
        this.renderFormat = builder.renderFormat;
        this.notificationContexts = builder.notificationContexts;
        this.previewingUser = builder.previewingUser;
        this.additionalContentFormat = builder.additionalContentFormat;
        this.stylingPreviewMessageField = builder.stylingPreviewMessageField;
        this.renderMode = builder.renderMode;
        this.variableCustomPreviewDataMap = builder.variableCustomPreviewDataMap;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(@Nonnull NotificationPreviewContext copy) {
        Builder builder = new Builder();
        builder.rawContent = copy.rawContent;
        builder.css = copy.css;
        builder.locale = copy.locale;
        builder.project = copy.project;
        builder.renderFormat = copy.renderFormat;
        builder.notificationContexts = copy.notificationContexts;
        builder.previewingUser = copy.previewingUser;
        builder.additionalContentFormat = copy.additionalContentFormat;
        builder.stylingPreviewMessageField = copy.stylingPreviewMessageField;
        builder.renderMode = copy.renderMode;
        builder.variableCustomPreviewDataMap = copy.variableCustomPreviewDataMap;
        return builder;
    }

    public String getRawContent() {
        return this.rawContent;
    }

    public Option<String> getCss() {
        return this.css;
    }

    public Locale getLocale() {
        return this.locale;
    }

    @Nonnull
    public Project getProject() {
        return this.project;
    }

    public NotificationRenderFormat getRenderFormat() {
        return this.renderFormat;
    }

    public Set<NotificationContext> getNotificationContexts() {
        return this.notificationContexts;
    }

    public CheckedUser getPreviewingUser() {
        return this.previewingUser;
    }

    public Option<Pair<NotificationRenderFormat, String>> getAdditionalContentFormat() {
        return this.additionalContentFormat;
    }

    public Option<CustomPreviewData> getProvidedCustomPreviewData(NotificationVariable notificationVariable) {
        return Option.option((Object)this.variableCustomPreviewDataMap.get(notificationVariable));
    }

    public StylingPreviewMessageField getStylingPreviewMessageField() {
        return this.stylingPreviewMessageField;
    }

    public RenderMode getRenderMode() {
        return this.renderMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotificationPreviewContext that = (NotificationPreviewContext)o;
        return this.renderMode == that.renderMode && Objects.equal((Object)this.rawContent, (Object)that.rawContent) && Objects.equal(this.css, that.css) && Objects.equal((Object)this.locale, (Object)that.locale) && Objects.equal((Object)this.project, (Object)that.project) && this.renderFormat == that.renderFormat && Objects.equal(this.notificationContexts, that.notificationContexts) && Objects.equal((Object)this.previewingUser, (Object)that.previewingUser) && Objects.equal(this.additionalContentFormat, that.additionalContentFormat);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.rawContent, this.css, this.locale, this.project, this.renderFormat, this.notificationContexts, this.previewingUser, this.additionalContentFormat, this.renderMode});
    }

    public static final class Builder {
        private String rawContent;
        private Option<String> css;
        private Locale locale;
        private Project project;
        private NotificationRenderFormat renderFormat;
        private Set<NotificationContext> notificationContexts;
        private CheckedUser previewingUser;
        private Option<Pair<NotificationRenderFormat, String>> additionalContentFormat;
        private StylingPreviewMessageField stylingPreviewMessageField;
        private RenderMode renderMode;
        private Map<NotificationVariable, CustomPreviewData> variableCustomPreviewDataMap;

        private Builder() {
        }

        @Nonnull
        public Builder withRawContent(@Nonnull String val) {
            this.rawContent = val;
            return this;
        }

        @Nonnull
        public Builder withCss(@Nonnull String val) {
            this.css = Option.option((Object)val);
            return this;
        }

        @Nonnull
        public Builder withLocale(@Nonnull Locale val) {
            this.locale = val;
            return this;
        }

        @Nonnull
        public Builder withProject(@Nonnull Project val) {
            this.project = val;
            return this;
        }

        @Nonnull
        public Builder withRenderFormat(@Nonnull NotificationRenderFormat val) {
            this.renderFormat = val;
            return this;
        }

        @Nonnull
        public Builder withNotificationContexts(@Nonnull Set<NotificationContext> val) {
            this.notificationContexts = val;
            return this;
        }

        @Nonnull
        public Builder withPreviewingUser(@Nonnull CheckedUser val) {
            this.previewingUser = val;
            return this;
        }

        @Nonnull
        public Builder withAdditionalContentFormat(@Nonnull Pair<NotificationRenderFormat, String> val) {
            this.additionalContentFormat = Option.option(val);
            return this;
        }

        @Nonnull
        public Builder withStylingPreviewMessageField(@Nonnull StylingPreviewMessageField val) {
            this.stylingPreviewMessageField = val;
            return this;
        }

        @Nonnull
        public Builder withRenderMode(@Nonnull RenderMode val) {
            this.renderMode = val;
            return this;
        }

        @Nonnull
        public Builder withVariableCustomPreviewDataMap(@Nonnull Map<NotificationVariable, CustomPreviewData> val) {
            this.variableCustomPreviewDataMap = val;
            return this;
        }

        @Nonnull
        public NotificationPreviewContext build() {
            return new NotificationPreviewContext(this);
        }
    }
}

