/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.feature.precondition;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.servicedesk.internal.api.notifications.GlobalNotificationsManager;
import com.atlassian.servicedesk.plugins.automation.api.configuration.ruleset.RuleSet;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.featureflag.SDNotificationsFeatureFlags;
import com.atlassian.servicedesk.plugins.notifications.internal.bootstrap.upgrade.task.NotificationDefaultRuleDefaults;
import com.atlassian.servicedesk.plugins.notifications.internal.defaultrules.migration.NotificationDefaultRuleGenerator;
import com.atlassian.servicedesk.plugins.notifications.internal.security.NotificationPermissionService;
import io.atlassian.fugue.Either;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotificationMisconfigurationService {
    private final NotificationPermissionService notificationPermissionService;
    private final NotificationDefaultRuleGenerator notificationDefaultRuleGenerator;
    private final GlobalNotificationsManager globalNotificationsManager;
    private final FeatureManager featureManager;
    private final NotificationDefaultRuleDefaults notificationDefaultRuleDefaults;

    @Autowired
    public NotificationMisconfigurationService(NotificationPermissionService notificationPermissionService, NotificationDefaultRuleGenerator notificationDefaultRuleGenerator, GlobalNotificationsManager globalNotificationsManager, FeatureManager featureManager, NotificationDefaultRuleDefaults notificationDefaultRuleDefaults) {
        this.notificationPermissionService = notificationPermissionService;
        this.notificationDefaultRuleGenerator = notificationDefaultRuleGenerator;
        this.globalNotificationsManager = globalNotificationsManager;
        this.featureManager = featureManager;
        this.notificationDefaultRuleDefaults = notificationDefaultRuleDefaults;
    }

    public Either<AnError, List<RuleSet>> fixMissingNotificationRules(ApplicationUser user, Project project) {
        if (this.featureManager.isEnabled(SDNotificationsFeatureFlags.NOTIFICATION_CUT_OVER)) {
            return this.notificationPermissionService.checkProjectAdminPermission(user, project.getId()).flatMap(userIsAllowed -> this.notificationDefaultRuleGenerator.createMissingRules(user, project, this.notificationDefaultRuleDefaults.getAllSystemRuleDescriptors(false), !this.globalNotificationsManager.isNotificationDisabled()));
        }
        return Either.right(Collections.emptyList());
    }
}

