/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dispatch;

import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntry;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationBatchKey;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class NotificationEntryCollector
implements Collector<NotificationBatchQueueEntry, Map<NotificationBatchKey, List<NotificationBatchQueueEntry>>, Map<NotificationBatchKey, List<NotificationBatchQueueEntry>>> {
    NotificationEntryCollector() {
    }

    @Override
    public Supplier<Map<NotificationBatchKey, List<NotificationBatchQueueEntry>>> supplier() {
        return HashMap::new;
    }

    @Override
    public BiConsumer<Map<NotificationBatchKey, List<NotificationBatchQueueEntry>>, NotificationBatchQueueEntry> accumulator() {
        return (map, entry) -> {
            NotificationBatchKey key = new NotificationBatchKey(entry.getRecipientID(), entry.getIssueId());
            ArrayList entryList = Lists.newArrayList((Object[])new NotificationBatchQueueEntry[]{entry});
            map.merge(key, entryList, (batchEntriesOfMap, batchEntriesToAdd) -> Stream.concat(batchEntriesOfMap.stream(), batchEntriesToAdd.stream()).distinct().collect(Collectors.toList()));
        };
    }

    @Override
    public BinaryOperator<Map<NotificationBatchKey, List<NotificationBatchQueueEntry>>> combiner() {
        return (firstMap, secondMap) -> {
            HashMap<NotificationBatchKey, List> result = new HashMap<NotificationBatchKey, List>((Map<NotificationBatchKey, List>)firstMap);
            for (NotificationBatchKey key : secondMap.keySet()) {
                result.merge(key, (List)secondMap.get(key), (batchEntriesOfFirstMap, batchEntriesToAddFromSecondMap) -> Stream.concat(batchEntriesOfFirstMap.stream(), batchEntriesToAddFromSecondMap.stream()).distinct().collect(Collectors.toList()));
            }
            return result;
        };
    }

    @Override
    public Function<Map<NotificationBatchKey, List<NotificationBatchQueueEntry>>, Map<NotificationBatchKey, List<NotificationBatchQueueEntry>>> finisher() {
        return map -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            map.forEach((key, value) -> builder.put(key, Collections.unmodifiableList(value)));
            return builder.build();
        };
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return Sets.newHashSet((Object[])new Collector.Characteristics[]{Collector.Characteristics.UNORDERED});
    }
}

