/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dispatch;

import com.atlassian.fugue.Either;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.pocketknife.step.StepsConverters;
import com.atlassian.servicedesk.api.user.UserFactory;
import com.atlassian.servicedesk.internal.api.ServiceDeskManager;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmail;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBody;
import com.atlassian.servicedesk.internal.api.notifications.model.ServiceDeskEmailBuilderFactory;
import com.atlassian.servicedesk.internal.api.notifications.render.NotificationMessageContextUtils;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntry;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.EmailSenderNameCreator;
import com.atlassian.servicedesk.plugins.notifications.internal.message.NotificationMessageMetaData;
import com.atlassian.servicedesk.plugins.notifications.internal.migration.MigrationStatusChecker;
import com.atlassian.servicedesk.plugins.notifications.internal.outgoingemail.settings.OutgoingEmailSettingsModel;
import com.atlassian.servicedesk.plugins.notifications.internal.subject.EmailSubjectManager;
import io.atlassian.fugue.Option;
import io.atlassian.fugue.Unit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class NotificationDispatchUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationDispatchUtils.class);
    private final UserFactory userFactory;
    private final ServiceDeskManager serviceDeskManager;
    private final NotificationMessageContextUtils notificationMessageContextUtils;
    private final ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory;
    private final EmailSenderNameCreator emailSenderNameCreator;
    private final EmailSubjectManager emailSubjectManager;
    private final MigrationStatusChecker migrationStatusChecker;

    @Autowired
    public NotificationDispatchUtils(UserFactory userFactory, ServiceDeskManager serviceDeskManager, NotificationMessageContextUtils notificationMessageContextUtils, ServiceDeskEmailBuilderFactory serviceDeskEmailBuilderFactory, EmailSenderNameCreator emailSenderNameCreator, EmailSubjectManager emailSubjectManager, MigrationStatusChecker migrationStatusChecker) {
        this.userFactory = userFactory;
        this.serviceDeskManager = serviceDeskManager;
        this.notificationMessageContextUtils = notificationMessageContextUtils;
        this.serviceDeskEmailBuilderFactory = serviceDeskEmailBuilderFactory;
        this.emailSenderNameCreator = emailSenderNameCreator;
        this.emailSubjectManager = emailSubjectManager;
        this.migrationStatusChecker = migrationStatusChecker;
    }

    io.atlassian.fugue.Either<AnError, ServiceDeskEmail> buildEmailWithContent(NotificationMessageMetaData metaData, List<NotificationBatchQueueEntry> entries, ServiceDeskEmailBody emailBody, OutgoingEmailSettingsModel settings) {
        return this.emailSenderNameCreator.determineSenderName(metaData, entries).flatMap(senderName -> this.buildEmailWithContentInternal(metaData, (String)senderName, emailBody, settings));
    }

    private io.atlassian.fugue.Either<AnError, ServiceDeskEmail> buildEmailWithContentInternal(NotificationMessageMetaData metaData, String senderName, ServiceDeskEmailBody emailBody, OutgoingEmailSettingsModel settings) {
        ServiceDeskEmail.Builder emailBuilder = this.serviceDeskEmailBuilderFactory.newBuilder();
        metaData.getIssue().forEach(arg_0 -> ((ServiceDeskEmail.Builder)emailBuilder).issue(arg_0));
        return Steps.begin(this.renderSubject(metaData, settings)).then(subject -> this.addReplyToHeaderToEmailBuilder(metaData, emailBuilder)).yield((subject, replyToHeaderSet) -> this.buildEmailWithMandatoryFields(metaData, (String)subject, emailBody, emailBuilder, senderName));
    }

    private io.atlassian.fugue.Either<AnError, String> renderSubject(NotificationMessageMetaData metaData, OutgoingEmailSettingsModel settings) {
        return this.emailSubjectManager.renderSubjectString(metaData, settings);
    }

    private ServiceDeskEmail buildEmailWithMandatoryFields(NotificationMessageMetaData metaData, String subject, ServiceDeskEmailBody emailBody, ServiceDeskEmail.Builder emailBuilder, String fromName) {
        emailBuilder.fromAddress(metaData.getProject().getEmail()).toAddress(metaData.getRecipient().getEmailAddress()).subject(subject).serviceDeskEmailBody(emailBody).fromName(fromName).projectContext(Option.some((Object)metaData.getProject()));
        if (this.migrationStatusChecker.isDefaultNotificationSendingEnabled()) {
            emailBuilder.includeMailServerSubjectPrefix(false);
        }
        return emailBuilder.build();
    }

    private io.atlassian.fugue.Either<AnError, Unit> addReplyToHeaderToEmailBuilder(NotificationMessageMetaData metaData, ServiceDeskEmail.Builder emailBuilder) {
        return (io.atlassian.fugue.Either)metaData.getIssue().fold(() -> io.atlassian.fugue.Either.right((Object)Unit.Unit()), issue -> this.addReplyToHeaderToEmailBuilder(metaData.getRecipient(), (Issue)issue, emailBuilder));
    }

    private io.atlassian.fugue.Either<AnError, Unit> addReplyToHeaderToEmailBuilder(ApplicationUser recipient, Issue issue, ServiceDeskEmail.Builder emailBuilder) {
        return this.retrieveReplyToHeader(recipient, issue).map(headerOpt -> {
            headerOpt.forEach(arg_0 -> ((ServiceDeskEmail.Builder)emailBuilder).replyToHeader(arg_0));
            return Unit.Unit();
        });
    }

    private io.atlassian.fugue.Either<AnError, Option<String>> retrieveReplyToHeader(ApplicationUser recipient, Issue issue) {
        return Steps.begin((io.atlassian.fugue.Either)StepsConverters.newerEither((Either)this.userFactory.wrap(recipient))).then(checkedUser -> this.serviceDeskManager.getServiceDeskForProject(issue.getProjectObject())).yield((checkedUser, serviceDesk) -> this.notificationMessageContextUtils.getReplyToHeader(checkedUser, issue, serviceDesk));
    }
}

