/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.servicedesk.plugins.notifications.internal.dispatch;

import com.atlassian.jira.entity.WithId;
import com.atlassian.jira.issue.Issue;
import com.atlassian.pocketknife.api.commons.error.AnError;
import com.atlassian.pocketknife.api.querydsl.DatabaseAccessor;
import com.atlassian.pocketknife.api.querydsl.DatabaseConnection;
import com.atlassian.pocketknife.step.Steps;
import com.atlassian.servicedesk.plugins.notifications.internal.analytics.NotificationAnalyticsEventHelper;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueDao;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntry;
import com.atlassian.servicedesk.plugins.notifications.internal.dao.NotificationBatchQueueEntryBuilder;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationBatchContextResolver;
import com.atlassian.servicedesk.plugins.notifications.internal.dispatch.NotificationMessageConsumer;
import com.atlassian.servicedesk.plugins.notifications.internal.message.RecipientNotificationMessage;
import com.atlassian.servicedesk.plugins.notifications.internal.rendering.NotificationEmailBodyRenderer;
import com.atlassian.servicedesk.plugins.notifications.internal.scheduler.NotificationBatchScheduler;
import io.atlassian.fugue.Either;
import io.atlassian.fugue.Unit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationBatchEntryCreator
implements NotificationMessageConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationBatchEntryCreator.class);
    private final NotificationEmailBodyRenderer notificationEmailBodyRenderer;
    private final NotificationBatchQueueDao notificationBatchQueueDao;
    private final DatabaseAccessor databaseAccessor;
    private final NotificationBatchContextResolver notificationBatchContextResolver;
    private final NotificationBatchScheduler notificationBatchScheduler;
    private final NotificationAnalyticsEventHelper notificationAnalyticsEventHelper;
    private final List<NotificationBatchQueueEntry> entries = new ArrayList<NotificationBatchQueueEntry>();

    NotificationBatchEntryCreator(NotificationEmailBodyRenderer notificationEmailBodyRenderer, NotificationBatchQueueDao notificationBatchQueueDao, DatabaseAccessor databaseAccessor, NotificationBatchScheduler notificationBatchScheduler, NotificationAnalyticsEventHelper notificationAnalyticsEventHelper) {
        this.notificationEmailBodyRenderer = notificationEmailBodyRenderer;
        this.notificationBatchQueueDao = notificationBatchQueueDao;
        this.databaseAccessor = databaseAccessor;
        this.notificationBatchScheduler = notificationBatchScheduler;
        this.notificationAnalyticsEventHelper = notificationAnalyticsEventHelper;
        this.notificationBatchContextResolver = new NotificationBatchContextResolver();
    }

    @Override
    public Either<AnError, Unit> consume(RecipientNotificationMessage message) {
        return Steps.begin(this.notificationEmailBodyRenderer.renderHtmlContent(message)).then(htmlContent -> this.notificationEmailBodyRenderer.renderTextContent(message)).yield((htmlContent, textContent) -> this.addNotificationEntryToBatchList(message, (String)htmlContent, (String)textContent));
    }

    @Override
    public void finalizeConsumption() {
        if (!this.entries.isEmpty()) {
            LOG.debug("Created {} batch notification entries", (Object)this.entries.size());
            this.databaseAccessor.run(databaseConnection -> this.notificationBatchQueueDao.create(this.entries, (DatabaseConnection)databaseConnection));
            this.notificationBatchScheduler.scheduleBatchSending();
            this.entries.clear();
        }
    }

    private Unit addNotificationEntryToBatchList(RecipientNotificationMessage message, String htmlContent, String textContent) {
        NotificationBatchQueueEntry entry = this.createNotificationBatchQueueEntry(message, htmlContent, textContent);
        this.addNotificationEntryToBatchList(entry);
        return Unit.Unit();
    }

    public void addNotificationEntryToBatchList(NotificationBatchQueueEntry entry) {
        this.entries.add(entry);
    }

    private NotificationBatchQueueEntry createNotificationBatchQueueEntry(RecipientNotificationMessage message, String htmlContent, String textContent) {
        this.notificationAnalyticsEventHelper.fireAnalyticsEvent("servicedesk.custom.notifications.dispatch.content", message.getProject().getId());
        if (!message.getTranslation().isSystemDefaultTranslation()) {
            this.notificationAnalyticsEventHelper.fireAnalyticsEvent("servicedesk.custom.notifications.dispatch.content.custom", message.getProject().getId());
        }
        return NotificationBatchQueueEntryBuilder.newBuilder().recipientId(message.getRecipient().getId()).projectId(message.getProject().getId()).issueId((Long)message.getIssue().map(Issue::getId).getOrNull()).htmlContent(htmlContent).textContent(textContent).eventTime(message.getEventTime()).authorId((Long)message.getEventInitiator().map(WithId::getId).getOrNull()).context(this.notificationBatchContextResolver.determineContext(message)).build();
    }
}

